
--Texture("starship")
--assert(false)

local raw_items = {}
for k, v in pairs(_G) do
  raw_items[k] = v
end

local gameworld = CreateFrame("Frame")
gameworld:SetAllPoints()
gameworld:SetLayer(-10)

assert(loadfile("terra.lua"))()
assert(loadfile("worldparams.lua"))()
assert(loadfile("editor_menu.lua"))()

local terra
local terraframe = CreateFrame("Frame", gameworld)
function terraframe:Draw()
  terra.render()
  terra.render_sprites()
end

local boundy = CreateFrame("Frame", gameworld)
boundy:SetPoint("TOPLEFT", UIParent, "TOPLEFT", -16, -12)
boundy:SetPoint("BOTTOMRIGHT", UIParent, "TOPLEFT", 16, 12)
boundy:SetBackgroundColor(0.1, 0.1, 0.1)
boundy:SetLayer(-2)

local select_sx = nil
local select_sy = nil
local select_active = nil
local function select_clear()
  terra.mergedown("select", 1)
end
local function select_zone(sx, sy, ex, ey)
  if sx > ex then sx, ex = ex, sx end
  if sy > ey then sy, ey = ey, sy end
  
  local sel, home = terra.layers["select"], terra.layers[1]
  
  for x = sx, ex do
    local x_sel, x_home = sel[x], home[x]
    for y = sy, ey do
      assert(not x_sel[y] or not x_home[y])
      x_sel[y] = x_sel[y] or x_home[y]
      x_home[y] = nil
    end
  end
end
local function deselect_zone(sx, sy, ex, ey)
  if sx > ex then sx, ex = ex, sx end
  if sy > ey then sy, ey = ey, sy end
  
  local sel, home = terra.layers["select"], terra.layers[1]
  
  for x = sx, ex do
    local x_sel, x_home = sel[x], home[x]
    for y = sy, ey do
      assert(not x_sel[y] or not x_home[y])
      x_home[y] = x_sel[y] or x_home[y]
      x_sel[y] = nil
    end
  end
end

local zooml = 0
local zoom_practical = 2
local xcenter = 0
local ycenter = 0
function get_mouse_nongrid()
  return GetMouseX() / 32 * zoom_practical + xcenter - zoom_practical * 16, GetMouseY() / 32 * zoom_practical + ycenter - zoom_practical * 12
end
function get_mouse_grid()
  local x, y = get_mouse_nongrid()
  return math.floor(x), math.floor(y)
end

local availkey_raw = "4567890rtyuiopfghjkl;vbnm,./"
local availkeys = {}
for k = 1, #availkey_raw do
  availkeys[availkey_raw:sub(k, k)] = true
end

local key2symbol = {}
local symbol2key = {}

local symbol2text = {}


local function attach_lookup(key, symbol)
  if key and #key == 1 then
    if symbol2key[symbol] then
      symbol2text[symbol]:SetText("")
      key2symbol[symbol2key[symbol]] = nil
      symbol2key[symbol] = nil
    end
    
    symbol2key[symbol] = key
    symbol2text[symbol]:SetText(key)
  end
  
  if key then
    if key2symbol[key] then
      symbol2key[key2symbol[key]] = nil
      symbol2text[key2symbol[key]]:SetText("")
      key2symbol[key] = nil
    end
    
    key2symbol[key] = symbol
  end
end



-- draw, entity, select
local mode = "draw"
local entity_selected = nil

local function make_palette(layout, decorate, draw_a_thing, there_is_a_key)
  assert(layout)
  
  local boxy = CreateFrame("Frame")
  tile_palette = boxy
  boxy:SetPoint("TOPLEFT", UIParent, "TOPLEFT")
  boxy:SetPoint("RIGHT", UIParent, "RIGHT")
  boxy:SetBackgroundColor(0, 0, 0, 0.5)

  local listostuff = CreateFrame("Frame", boxy)
  listostuff:SetPoint("TOPLEFT", boxy, "TOPLEFT", 20, 20)
  listostuff:SetPoint("RIGHT", boxy, "RIGHT", -20, nil)

  do
    local piecewid = 24
    local piecebord = 4
    local tween = 8
    
    local last_v = nil
    for _, t in ipairs(layout) do
      local last_h = nil
      for _, i in ipairs(t) do
        
        local bound = CreateFrame("Frame", listostuff)
        if not last_h then
          if not last_v then
            bound:SetPoint("TOPLEFT", listostuff, "TOPLEFT", 0, 0)
          else
            bound:SetPoint("TOPLEFT", last_v, "BOTTOMLEFT", 0, tween)
          end
          last_v = bound
        else
          bound:SetPoint("TOPLEFT", last_h, "TOPRIGHT", tween, 0)
        end
        last_h = bound
        bound:SetBackgroundColor(1, 1, 1, 0.3)
        
        local cont = CreateFrame("Frame", bound)
        cont.Draw = function (self)
          draw_a_thing(self, i)
        end
        
        cont:SetWidth(piecewid)
        cont:SetHeight(piecewid)
        cont:SetPoint("TOPLEFT", bound, "TOPLEFT", piecebord, piecebord)
        bound:SetPoint("BOTTOMRIGHT", cont, "BOTTOMRIGHT", piecebord, piecebord)
        
        decorate(bound, cont, i)
        
        bound.Key = function (self, ...)
          there_is_a_key(self, i, ...)
        end
      end
      if not last_h then
        local spacer = CreateFrame("Frame", listostuff)
        spacer:SetHeight(piecewid + piecebord * 2)
        spacer:SetPoint("TOPLEFT", last_v, "BOTTOMLEFT", 0, tween)
        last_v = spacer
      end
    end
    
    listostuff:SetPoint("BOTTOM", last_v, "BOTTOM", 0, 0)
  end
  listostuff:SetBackgroundColor(0, 0, 0, 0.5)

  --[[
  local butan = CreateFrame("Button", boxy)
  butan:SetPoint("TOPRIGHT", listostuff, "BOTTOMRIGHT", nil, 20)
  butan:SetHeight(50)
  butan:SetWidth(200)
  butan:SetBackgroundColor(0.5, 0.5, 0.5)
  function butan:Click()
    boxy:Hide()
  end]]

  print("START", UIParent, listostuff, boxy)
  boxy:SetPoint("BOTTOM", listostuff, "BOTTOM", nil, 20)
  print("END", UIParent, listostuff, boxy)

  boxy:Hide()
  
  return boxy
end

local tile_palette = make_palette(mappiece_layout,
  function(boundary, contents, item)
    local tex = CreateFrame("Text", boundary)
    tex:SetColor(1, 1, 1)
    tex:SetPoint("BOTTOMRIGHT", boundary, "BOTTOMRIGHT", -6, 0)
    tex:SetText("")
    symbol2text[item] = tex
  end,
  function(self, item)
    local v = mappieces[item]
    if v.tex then
      Texture(v.tex):SetTexture()
      gl.Color(1, 1, 1)
      gl.Disable("CULL_FACE")
      gl.Begin("TRIANGLES")
      
      assert(v, item)
        --if x < xcenter - 1 or x > xcenter + 32 then continue end
      
      local x, y = self:GetLeft(), self:GetTop()

      for vtx = 3, #v - 2, 2 do
        gl.TexCoord(v[1], v[2])
        gl.Vertex(x + v[1] * 32, y + v[2] * 32)
        gl.TexCoord(v[vtx], v[vtx + 1])
        gl.Vertex(x + v[vtx] * 32, y + v[vtx + 1] * 32)
        gl.TexCoord(v[vtx + 2], v[vtx + 3])
        gl.Vertex(x + v[vtx + 2] * 32, y + v[vtx + 3] * 32)
      end
      gl.End()
      SetNoTexture()
    end
  end,
  function(self, item, button, ascii, event)
    if not ascii then return true end
    if event ~= "press" then return true end
    if not availkeys[ascii] then return true end
    
    attach_lookup(ascii, item)
  end
)

local entity_palette = make_palette(entity_layout,
  function(boundary, contents, item)
  end,
  function(self, item)
    glutil.RenderBoundedSprite(Texture(entities[item].tex), {self:GetBounds()}, entities[item].r, entities[item].g, entities[item].b)
  end,
  function(self, item, button, ascii, event)
    if event == "press" and button == "mouse_left" then
      entity_selected = item
    end
  end
)

do
  local fil = CreateMenu()
  fil:AddCommand("Open", function ()
    coroutine.background(function ()
      local button, box = TextEntryDialog("Open")
      if button == "OK" then
        terra.load(io.snatch("level_" .. box .. ".lev.lua"))
      end
      return true
    end)
  end)
  fil:AddCommand("Save As", function ()
    coroutine.background(function ()
      local button, box = TextEntryDialog("Save")
      if button == "OK" then
        select_clear()
        io.dump("level_" .. box .. ".lev.lua", terra.save())
      end
      return true
    end)
  end)
  MainMenu:AddSubmenu("File", fil)
end


local function reset()
  terra = terra_init(mappieces, entities)
  collectgarbage("collect")
end
reset()

terra.load(io.snatch("test.lev.lua"))  -- likewise, the same is true of your maternal relative

local playtest

function loop(tix)
  if playtest then
    if playtest.loop then playtest.loop(tix) end
    if playtest.totallydone then playtest = nil ShowMouseCursor(true) end
    return
  end
  
  if GetFocus() then return end
  
  if IsKeyDownFrame("a") then xcenter = xcenter - 0.04 * tix * zoom_practical end
  if IsKeyDownFrame("w") then ycenter = ycenter - 0.04 * tix * zoom_practical end
  if IsKeyDownFrame("d") then xcenter = xcenter + 0.04 * tix * zoom_practical end
  if IsKeyDownFrame("s") then ycenter = ycenter + 0.04 * tix * zoom_practical end
end
function tick_loop(tix)
  if playtest then
    if playtest.tick_loop then playtest.tick_loop(tix) end
    if playtest.totallydone then playtest = nil ShowMouseCursor(true) end
    return
  end
end
function render(...)
  if playtest then
    if playtest.render then
      playtest.render(...)
    end
    playtest.UIRoot:Render()
    return
  end
  
  gameworld:SetCoordinateScale(xcenter, ycenter, 32 * zoom_practical)
end
local active = nil
local mouse_draw_down = false
function key(button, ascii, event)
  if playtest then
    if button == "f2" and event == "press" then
      playtest.UIRoot:Detach()
      UIParent:Show()
      playtest = nil
      ShowMouseCursor(true)
      return
    end
    
    if playtest.key then
      playtest.key(button, ascii, event)
    end
    return
  else
    if button == "f2" and event == "press" then
      print("spawning level")
      select_clear()
      io.dump("playtest.lev.lua", terra.save())
      
      playtest = runuifile("main.lua", "playtest")
      UIParent:Hide()
    end
  end
  
  if button == "q" and event == "press" then
    if mode == "draw" then
      tile_palette:Show(not tile_palette:IsShown())
    elseif mode == "entity" then
      entity_palette:Show(not entity_palette:IsShown())
    end
  end
  if button == "e" and event == "press" then
    MainMenu:Show(not MainMenu:IsShown())
  end
  
  if button == "1" and event == "press" then
    tile_palette:Hide()
    entity_palette:Hide()
    select_clear()
    entity_selected = nil
    mode = "draw"
  end
  if button == "2" and event == "press" then
    tile_palette:Hide()
    entity_palette:Hide()
    select_clear()
    mode = "entity"
  end
  if button == "3" and event == "press" then
    tile_palette:Hide()
    entity_palette:Hide()
    entity_selected = nil
    mode = "select"
  end
  
  if mode == "draw" then
    if button == "mouse_left" then
      if event == "press" then
        mouse_draw_down = true
      end
      if event == "release" then
        mouse_draw_down = false
      end
      
      if event == "frame" and not mouse_draw_down then return end
    end
  
    local tx, ty = get_mouse_grid()
    
    if event == "press" or event == "press_repeat" or event == "frame" then
      if button == "mouse_right" then
        attach_lookup("mouse_left", terra.layers[1][tx][ty])
      end
      
      if availkeys[button] or button == "mouse_left" then
        if key2symbol[button] or button == "mouse_left" then
          terra.layers[1][tx][ty] = key2symbol[button]
        end
      end
      
      if button == "c" then
        function floodfill(x, y, src, dest)
          if terra.layers[1][x][y] ~= src then return end
          
          terra.layers[1][x][y] = dest
          
          floodfill(x + 1, y, src, dest)
          floodfill(x - 1, y, src, dest)
          floodfill(x, y + 1, src, dest)
          floodfill(x, y - 1, src, dest)
        end
        
        local dst = key2symbol["mouse_left"]
        local src = terra.layers[1][tx][ty]
        if dst ~= src then floodfill(tx, ty, src, dst) end
      end
    end
  elseif mode == "entity" then
    if event == "press" then
      local tx, ty = get_mouse_nongrid()
      
      if entity_selected and entities[entity_selected].grid then
        tx, ty = math.round(tx - entities[entity_selected].width / 2) + entities[entity_selected].width / 2, math.round(ty - entities[entity_selected].height / 2) + entities[entity_selected].height / 2
      end
      
      if entity_selected and button == "mouse_right" then
        entity_selected = nil
      elseif entity_selected and button == "mouse_left" then
        table.insert(terra.entities(), {id = entity_selected, x = tx, y = ty})
        entity_selected = nil
      elseif not entity_selected and button == "mouse_left" then
        for k, v in ipairs(terra.entities()) do
          if tx >= v.x - entities[v.id].width / 2 and tx <= v.x + entities[v.id].width / 2 and 
            ty >= v.y - entities[v.id].height / 2 and ty <= v.y + entities[v.id].height / 2 then
            table.remove(terra.entities(), k)
            entity_selected = v.id
          end
        end
      end
    end
  elseif mode == "select" then
    if event == "press" and button == "mouse_right" then
      select_clear()
    elseif event == "press" and button == "mouse_left" then
      select_sx, select_sy = get_mouse_grid()
      
      if IsKeyDownFrame("shift") or IsKeyDownFrame("ctrl") or not terra.layers["select"][select_sx][select_sy] then
        if not IsKeyDownFrame("shift") and not IsKeyDownFrame("ctrl") then
          select_clear()
        end
      else
        select_active = true
      end
      
    elseif event == "release" and button == "mouse_left" then
      if select_sx and select_sy then
        local select_ex, select_ey = get_mouse_grid()
        if select_active then
          terra.shiftlayer("select", select_ex - select_sx, select_ey - select_sy)
        elseif IsKeyDownFrame("ctrl") then
          deselect_zone(select_sx, select_sy, select_ex, select_ey)
        else
          select_zone(select_sx, select_sy, select_ex, select_ey)
        end
        
        select_sx, select_sy = nil, nil
        select_active = nil
      end
    elseif event == "press" and button == "delete" then
      terra.eraselayer("select")
    end
  end
end
function failover()
  if playtest and playtest.failover then
    playtest.failover()
  end
  local dumpl = "crashmelt_" .. os.time() .. ".lev.lua"
  io.dump(dumpl, terra.save())
  
  return dumpl
end
function de_failover(tok)
  if tok then
    terra.load(io.snatch(tok))
  end
end

ShowMouseCursor(true)

