
local frameid = 0

local _, _, lev, traces, pos, total_to_spawn = ...
assert(lev)

loadfile("scaffold.lua")()
loadfile("terra.lua")()
loadfile("worldparams.lua")()

local terra = terra_init(mappieces, entities)
terra.load(assert(io.snatch(lev == "playtest" and "playtest.lev.lua" or "level_" .. lev .. ".lev.lua"), lev))
local gameworld = CreateFrame("Frame")
gameworld:SetAllPoints()  
gameworld:SetCoordinateScale(0, 0, 32)
function gameworld:Draw()
  terra.render()
end

local scaffold = scaffold_init()
terra.scaffoldize(scaffold.InsertLine)

local player
local clones = {}
local entry
local exits = {}
local gizmos = {}
local walls_by_type = {}
local tuttons_aggregate = {}
local tuttons_per = {}
local tuttons_lookup = {}
local blinkers = {{}, {}}
local function roberts()
  local play = {}
  for k, v in pairs(clones) do
    table.insert(play, v)
  end
  table.insert(play, player)
  return play
end

local function collide(one, two)
  return math.abs(two.x - one.x) * 2 <= two.width + one.width and math.abs(two.y - one.y) * 2 <= two.height + one.height
end
local function cpt(x, s, e)
  return x >= s and x <= e
end
local function contained(one, two, boost)
  local bost = boost and 0.1 or 0
  local osx, osy, oex, oey = one.x - one.width / 2, one.y - one.height / 2, one.x + one.width / 2, one.y + one.height / 2
  local tsx, tsy, tex, tey = two.x - two.width / 2, two.y - two.height / 2 - bost, two.x + two.width / 2, two.y + two.height / 2 + bost
  return cpt(osx, tsx, tex) and cpt(oex, tsx, tex) and cpt(osy, tsy, tey) and cpt(oey, tsy, tey)
end

local function playerconflict(x, y, two)
  local tsx, tsy, tex, tey = two.x - two.width, two.y - two.height, two.x + two.width, two.y + two.height
  return cpt(x, tsx, tex) and cpt(y, tsy, tey)
end

local function intersect(one, two)
  local hafw, hafh = (one.width + two.width) / 2, (one.height + two.height) / 2
  local tsx, tsy, tex, tey = two.x - hafw, two.y - hafh, two.x + hafw, two.y + hafh
  return cpt(one.x, tsx, tex) and cpt(one.y, tsy, tey)
end

local function corpsify(target)
  target.bouncefactor = 0.55
  target.bouncelimit = 0.01
  target.gravity = 1
  target.freefall = true
  target.dead = true
  
  target.think = function ()
    if not target.freefall then
      target.xvel = approach(target.xvel, 0, 0.01)
    end
  end
  target.coro = nil
end

local function boxit(targ, lines)
  local sx, sy, ex, ey = targ.x - targ.width / 2, targ.y - targ.height / 2, targ.x + targ.width / 2, targ.y + targ.height / 2
  -- then we turn our box back on
  lines[1].sx, lines[1].sy, lines[1].ex, lines[1].ey = sx, sy, ex, sy
  lines[2].sx, lines[2].sy, lines[2].ex, lines[2].ey = sx, sy, sx, ey
  lines[3].sx, lines[3].sy, lines[3].ex, lines[3].ey = ex, sy, ex, ey
  lines[4].sx, lines[4].sy, lines[4].ex, lines[4].ey = sx, ey, ex, ey
end

function NewMonster(monster, id)
  local ent = scaffold.Entity(monster.x, monster.y)
  local self = ent
  
  ent.width, ent.height = entities[monster.id].width, entities[monster.id].height
  ent.sprite = CreateFrame("Sprite", gameworld)
  ent.sprite:SetTexture(entities[monster.id].tex)
  ent.sprite:SetWidth(ent.width)
  ent.sprite:SetHeight(ent.height)
  ent.sprite:SetColor(entities[monster.id].r, entities[monster.id].g, entities[monster.id].b)

  if not entities[monster.id].flying and not entities[monster.id].not_real then
    scaffold.ground_anchor(ent)
  end
  
  ent.sprite:SetPoint("CENTER", UIParent, "TOPLEFT", ent.x, ent.y)
  ent.sprite:Show()
  
  if monster.id:find("field") then
    ent.unid_field = true
    ent.lines = {{}, {}, {}, {}}
    boxit(ent, ent.lines)
    
    ent.sprite:SetColor(0.5, 0.5, 1)
    
    function ent:tick()
      if not ent.unid_field then return end
      
      for _, v in pairs(roberts()) do
        if intersect(self, v) then
          if ent.unid_field then
            -- we get owned
            if v == player then
              ent.sprite:SetColor(0, 0, 0.6)
            else
              ent.sprite:SetColor(1, 1, 1)
            end
            
            table.insert(v.boxes, ent)
            self:add()
            
            ent.unid_field = nil
          end
        end
      end
    end
    
    function ent:remove()
      for _, v in pairs(self.lines) do
        scaffold.RemoveDynamicLine(v)
      end
    end
    function ent:add()
      for _, v in pairs(self.lines) do
        scaffold.InsertDynamicLine(v)
      end
    end
  elseif monster.id == "movewall" then
    ent.lines = {{}, {}, {}, {}}
    function ent:tick()
      self.y = self.y - 0.01
      boxit(ent, ent.lines)
      for _, v in pairs(self.lines) do
        scaffold.InsertDynamicLine(v)
      end
      self.sprite:SetPoint("CENTER", UIParent, "TOPLEFT", self.x, self.y)
    end
  elseif monster.id:find("button") then
    local chunk = monster.id:match("button_(.*)")
    assert(chunk)
    
    if monster.id:find("tbutton") then
      ent.time_id = id
      tuttons_lookup[id] = chunk
    end
    
    function ent:poosh()
      self.used = true
      local r, g, b = self.sprite:GetColor()
      self.sprite:SetColor(r / 2, g / 2, b / 2)
      
      if ent.time_id then
        tuttons_aggregate[chunk] = (tuttons_aggregate[chunk] or 0) + 1
        tuttons_per[ent.time_id] = true
      end
      
      if walls_by_type[chunk] then
        for _, v in pairs(walls_by_type[chunk]) do
          v:toggle()
        end
      end
    end
    function ent:tick()
      if self.used then return end
      for _, v in pairs(roberts()) do
        if intersect(self, v) then
          self:poosh()
        end
      end
    end
  elseif monster.id:find("wall") then
    local state, chunk = monster.id:match("wall(.*)_(.*)")
    assert(state and chunk)
    
    state = (state == "on")
    if state then -- we make it dim 'cause we'll be brightening it later
      local r, g, b = self.sprite:GetColor()
      self.sprite:SetColor(r / 2, g / 2, b / 2)
    end
    
    do
      local r, g, b = self.sprite:GetColor()
      self.sprite:SetColor(r / 2, g / 2, b / 2)
    end
    
    local ftog = state  -- again, cache for later brightening
    state = false
    
    ent.lines = {{}, {}, {}, {}}
    boxit(ent, ent.lines)
    function ent:toggle()
      if state then
        local r, g, b = self.sprite:GetColor()
        self.sprite:SetColor(r / 4, g / 4, b / 4)
        for _, v in pairs(self.lines) do
          scaffold.RemoveDynamicLine(v)
        end
      else
        local r, g, b = self.sprite:GetColor()
        self.sprite:SetColor(r * 4, g * 4, b * 4)
        for _, v in pairs(self.lines) do
          scaffold.InsertDynamicLine(v)
        end
      end
      
      state = not state
    end
    
    local stt = false
    function ent:softtoggle()
      local amnow = state
      if stt then amnow = not amnow end
      if amnow then
        for _, v in pairs(self.lines) do
          scaffold.RemoveDynamicLine(v)
        end
      else
        for _, v in pairs(self.lines) do
          scaffold.InsertDynamicLine(v)
        end
      end
      stt = not stt
    end
    
    ent.tick = function () end
    
    if ftog then ent:toggle() end
    
    if not walls_by_type[chunk] then walls_by_type[chunk] = {} end
    table.insert(walls_by_type[chunk], ent)
  elseif monster.id == "entry" or monster.id == "exit" or monster.id == "robert" then
  elseif monster.id:find("blinker") then
    local polarity = monster.id:match("blinker_(.*)")
    if polarity == "even" then polarity = 0 else polarity = 1 end
    
    local solid = (math.mod(#traces + polarity, 2) == 1)
    if solid then
      ent.sprite:SetColor(1, 1, 1)
    else
      ent.sprite:SetColor(0.25, 0.25, 0.25)
    end
    
    table.insert(blinkers[polarity + 1], ent)
    
    ent.lines = {{}, {}, {}, {}}
    boxit(ent, ent.lines)
    
    function ent:add()
      for _, v in pairs(self.lines) do
        scaffold.InsertDynamicLine(v)
      end
    end
    function ent:remove()
      for _, v in pairs(self.lines) do
        scaffold.RemoveDynamicLine(v)
      end
    end
    function ent:tick()
    end
    ent:add()
  else
    assert(false, monster.id)
  end
  
  return ent
end

for id, v in ipairs(terra.entities()) do
  local nm = NewMonster(v, id)
  
  if v.id == "entry" then
    entry = nm
  elseif v.id == "exit" then
    table.insert(exits, nm)
  else
    gizmos[nm] = true
  end
end

-- this is where we jam stuff into tuttons
if #traces > 0 then
  local tfinal = traces[#traces][#traces[#traces]].tuttons
  for k in pairs(tfinal) do
    local found = false
    for v, _ in pairs(gizmos) do
      if v.time_id == k then
        found = true
        v:poosh()
      end
    end
    assert(found)
  end
end

function finishitup(msg, suppress)
  local traces = {}
  for _, v in pairs(clones) do
    table.insert(traces, v.events)
  end
  if not suppress then
    table.insert(traces, player.events)
  end
  if type(suppress) == "number" then
    for i = 2, suppress do
      table.remove(traces)
    end
  end
  
  -- we'll do something similar if we die
  message({msg, traces})
end

local blinkerpolar = 1
function playerize(player)
  local walk_top_speed = 5 / 60
  local run_top_speed = 5 / 60
  local jump_top_speed = 5 / 60
  local start_accel = 0.01
  local stop_accel = 0.02
  local stop_accel_air = 0.0040
  local jump_yvel = 0.2

  local jumplift_grav = 0.7
  local jumpdown_grav = 0.7

  player.mirror = true
  player.direction = 1
  
  player.events = {}
  player.sprite:SetLayer(#clones + 2)
  
  player.lines = {{}, {}, {}, {}} -- these get filled in before they get added
  
  player.boxes = {}
  
  player.blinkers = blinkers[blinkerpolar]
  blinkerpolar = blinkerpolar + 1
  if blinkerpolar == 3 then blinkerpolar = 1 end
  
  function player:mover(x, y, jumpy)
    if self.dead then x = 0 y = 0 jumpy = false end
    
    if x ~= 0 then
      if self.state == "stopped" then
        self.state = "running"
      end
      
      self.direction = x / math.abs(x)
    elseif self.invincibility ~= true then
      local stop_acel = (self.freefall and stop_accel_air or stop_accel)
      if stop_acel > math.abs(self.xvel) then
        self.xvel = 0
        if not self.freefall then self.state = "stopped" end
      else
        if self.xvel > 0 then stop_acel = -stop_acel end
        self.xvel = self.xvel + stop_acel
      end
    end
    
    if self.gravity < jumpdown_grav then
      self.gravity = self.gravity + 0.025
    end
    
    if y < 0 and not self.freefall and jumpy then
      self.freefall = true
      self.gravity = jumplift_grav
      self.yvel = -jump_yvel
      self.state = "run_jump"
    end
    
    if y >= 0 and self.freefall and self.yvel < 0 and self.gravity < jumpdown_grav then
      self.yvel = self.yvel / 2
      self.gravity = jumpdown_grav
    end
    
    if self.state == "run_jump" and self.yvel > 0 then
      self.state = "run_jump_fall"
      self.gravity = jumpdown_grav
    end
    
    if x > 0 then
      self.xacel = start_accel
    elseif x < 0 then
      self.xacel = -start_accel
    else
      self.xacel = 0
    end
    
    if self.xacel * self.xvel < 0 then
      self.xacel = self.xacel * 2
    end
    
    if self.invincibility ~= true then
      local top_speed
      if self.state == "stopped" or self.state == "end_run_jump" then
        top_speed = walk_top_speed
      elseif self.state == "running" then
        top_speed = run_top_speed
      elseif self.state == "run_jump" or self.state == "run_jump_fall" or self.state == "start_run_jump" then
        top_speed = jump_top_speed
      else
        top_speed = 1000
      end
      
      local expected_speed = self.xvel + self.xacel
      if math.abs(expected_speed) > top_speed then
        self.xacel = (top_speed - math.abs(expected_speed)) * (expected_speed / math.abs(expected_speed))
      end
    end
  end
  function player:cycle(dx, dy, jump)
    player:mover(dx, dy, jump)  -- first we move
    player:tick() -- then we tick
    
    local tt = {}
    for k, v in pairs(tuttons_per) do
      tt[k] = v
    end
    table.insert(player.events, {dx = dx, dy = dy, jump = jump, px = self.x, py = self.y, tuttons = tt})
    -- then we record the movements, as well as our locations on this frame, for later replaying
  end
  
  local ltick = player.tick
  function player:tick()
    -- first we disable our own box and boxes of one-character obstructions "owned" by us
    for _, v in pairs(self.lines) do
      scaffold.RemoveDynamicLine(v)
    end
    for _, v in pairs(self.boxes) do
      v:remove()
    end
    -- blinkers that don't apply to us
    for _, v in pairs(self.blinkers) do
      v:remove()
    end

    -- make sure we didn't paradox all over the floor
    if not scaffold.is_valid_location(self.x, self.y, self.width, self.height) then
      self.sprite:SetTexture("robert_dead")
      self.sprite:SetHeight(self.height)
      self.sprite:SetWidth(self.width)
      print("FINISHITUP WHOOPS")
      finishitup("whoops", true)
    end
    
    -- tix
    ltick(player)
    
    boxit(self, self.lines)
    for _, v in pairs(self.lines) do
      scaffold.InsertDynamicLine(v)
    end
    for _, v in pairs(self.boxes) do
      v:add()
    end
    for _, v in pairs(self.blinkers) do
      v:add()
    end
  end
end

local function CreatePlayer()
  local play = NewMonster({x = entry.x, y = entry.y, id = "robert"})
  playerize(play)
  return play
end

local function cloneize(clone)
  clone.sprite:SetColor(0.8, 0.8, 0.8)
  clone.clonetick = coroutine.wrap(function()
    for _, v in pairs(clone.events) do
    
      -- gonna have to deal with tutton walls here
      -- first we figure out the relative polarity of tutton walls
      local relpol = {}
      for k in pairs(v.tuttons) do
        local c = tuttons_lookup[k]
        relpol[c] = (relpol[c] or 0) + 1
      end
      for k, v in pairs(tuttons_aggregate) do
        relpol[k] = (relpol[k] or 0) - v
      end
      for k, v in pairs(relpol) do
        relpol[k] = (math.mod(v, 2) ~= 0)
      end
      
      local tbt = {}
      -- then we invert all the walls that need to be inverted
      for k, v in pairs(relpol) do
        if v then
          for _, v in pairs(walls_by_type[k]) do
            table.insert(tbt, v)
          end
        end
      end
      
      for _, v in pairs(tbt) do
        v:softtoggle()
      end
      
      clone:mover(v.dx, v.dy, v.jump)
      clone:tick()
      
      -- then we re-invert them
      for _, v in pairs(tbt) do
        v:softtoggle()
      end
      
      if clone.x ~= v.px or clone.y ~= v.py then
        print("Desynch!", clone.x, v.px, clone.y, v.py, clone.x - v.px, clone.y - v.py)
        if math.abs(clone.x - v.px) < 0.001 and math.abs(clone.y - v.py) < 0.001 then
          clone.x, clone.y = v.px, v.py
        else
          clone.sprite:SetTexture("robert_dead")
          clone.sprite:SetHeight(clone.height)
          clone.sprite:SetWidth(clone.width)
          finishitup("whoops", true)
        end
      end
      coroutine.yield()
    end
    
    -- we know we've gotten to the end here
    clone.x = -1000
    clone.y = -1000
    clone.sprite:Hide()
    clone.win = true
    
    for _, v in pairs(clone.lines) do
      scaffold.RemoveDynamicLine(v)
    end
    
    while true do
      --clone:mover(0, 0, 0)
      --clone:tick()  -- we is done, why is we doing this
      coroutine.yield()
    end
  end)
end

local function wait_until_spawn()
  local wct = 0
  while true do
    local spawny = true
    for _, v in pairs(clones) do
      if playerconflict(entry.x, entry.y, v) then
        spawny = false
        break
      end
    end
    
    if spawny then
      wct = wct + 1
    else
      wct = 0
    end
    
    if wct >= 15 then break end
    
    coroutine.yield()
  end
  
  print("spawning clone at", frameid)
end

local spawn_indicators = {}

do
  local spawn_anchor = CreateFrame("Frame", entry.sprite)
  spawn_anchor:SetPoint(0.5, nil, entry.sprite, 0.5, nil)
  spawn_anchor:SetPoint("TOP", entry.sprite, "TOP", nil, -0.05)
  print("TTS:", total_to_spawn)
  for i = 1, math.min(total_to_spawn, 10) - 1 do
    local light = CreateFrame("Frame", spawn_anchor)
    light:SetPoint(0.5, nil, spawn_anchor, 0.5, nil)
    light:SetPoint("BOTTOM", spawn_anchor, "TOP", nil, -0.1)
    
    light:SetHeight(0.2)
    light:SetWidth(0.5)
    light:SetBackgroundColor(0, 1, 0)
    spawn_anchor = light
    table.insert(spawn_indicators, light)
  end
end

local spawnix = coroutine.wrap(function ()
  local nxt = 1
  if traces then
    for t, v in pairs(traces) do
      wait_until_spawn()
        
      -- spawn a clone
      local play = CreatePlayer()
      spawn_indicators[nxt]:SetBackgroundColor(0.1, 0.1, 0.1)
      nxt = nxt + 1
      play.events = v
      cloneize(play)
      table.insert(clones, play)
    end
  end
  
  wait_until_spawn()
  
  -- spawn a player
  player = CreatePlayer()
  
  while true do coroutine.yield() end
end)

--[[local playerlifebox = CreateFrame("Frame")
playerlifebox:SetLayer(1000)
playerlifebox:SetWidth(250)
playerlifebox:SetHeight(100)
playerlifebox:SetPoint("CENTER", UIParent, "CENTER", 0, -300)
playerlifebox:SetBackgroundColor(0, 0, 0)
local playerlifeframe = CreateFrame("Text", playerlifebox)
playerlifeframe:SetPoint("CENTER", playerlifebox, "CENTER")
playerlifeframe:SetColor(1, 1, 1)
playerlifeframe:SetSize(40)
playerlifebox:Hide()]]

if pos == "right" then
  playerlifebox:SetPoint("CENTER", UIParent, "CENTER", 350, -300)
end

local process = coroutine.wrap(function ()
  local playerlife = nil
  
  local playerwin = false
  
  while true do
    if player then
      -- check to see if we're in the exit
      for _, k in pairs(exits) do
        if contained(player, k, true) then
          -- yaaaaay
          playerwin = true
          --playerlifebox:Hide()
          player.sprite:Hide()
          for _, v in pairs(player.lines) do
            scaffold.RemoveDynamicLine(v)
          end
          -- we keep running it until everyone's escaped, though
        end
      end
    end
    
    local nop = not player
    
    for i = 1, 4 do
      frameid = frameid + 1
      
      spawnix()
      
      -- if all clones have won, and the player has won, then we're done
      do
        local win = playerwin
        for _, v in pairs(clones) do
          if not v.win then win = false end
        end
        if win then
          finishitup("yay")
        end
      end
      
      for v in pairs(gizmos) do
        if v.tick then v:tick() end
      end
      for _, v in pairs(clones) do
        v:clonetick()
      end
      
      if playerlife and not playerwin then playerlife = playerlife - 1 end
      
      if player and not playerwin then break end
    end
    
    if nop and player then
      --playerlife = 600
      --playerlifebox:Show()
      --playerlifeframe:SetText(string.format("%5.2f", playerlife / 60))
      message("player_spawned")
      coroutine.yield()
      -- pause until the player does something
      while not WasKeyPressed("arrow_up") and not WasKeyPressed("arrow_left") and not WasKeyPressed("arrow_right") and not WasKeyPressed(" ") and not WasKeyPressed("x") do
        coroutine.yield()
      end
      if WasKeyPressed("x") then
        finishitup("reverse", 2)
      end
    end
    
    --[[if playerlife == 0 then
      finishitup("splat", true)
    end]]
    
    --[[if playerlife then
      playerlifeframe:SetText(string.format("%5.2f", playerlife / 60))
    end]]
    
    if WasKeyPressed("x") then
      if not player then
        finishitup("reverse", 2)
      else
        finishitup("reverse", 1)
      end
    end
    
    if player and not playerwin then
      local dx, dy = 0, 0
      local speed = 1
      
      if IsKeyDownFrame("arrow_up") or IsKeyDownFrame(" ") then dy = dy - speed end
      if IsKeyDownFrame("arrow_left") then dx = dx - speed end
      if IsKeyDownFrame("arrow_right") then dx = dx + speed end
      
      local jump = WasKeyPressed("arrow_up") or WasKeyPressed(" ")
      
      player:cycle(dx, dy, jump)
    end
    
    coroutine.yield()
  end
end)

local trigger_suicide = false
local trigger_restart = false

function tick_loop(...)
  if trigger_suicide then coroutine.wrap(function () finishitup("reverse", 1) end)() end
  if trigger_restart then coroutine.wrap(function () message("restart") end)() end
  process()
end


GlorpController("repopulate_menu", {
  {text = "Suicide", event = function () trigger_suicide = true end},
  {text = "Restart level", event = function () trigger_restart = true end},
})
