
ShowMouseCursor(false)

local _, _, levoverride, firstlev, core_levels, core_segments = ...

local textses = {
  jumps_intro = {
    "Say hello, Robert.",
    '"Hello, Robert."',
    "Robert has just woken up, and doesn't know where he is.",
    "Robert knows that he doesn't want to be here.",
    "Poor Robert.",
    "Perhaps Robert should escape.",
    "Why don't you help Robert escape?",
    "Use the arrow keys to move Robert to the door.",
  },
  jumps_exit = {
    "Good job! Robert has escaped.",
  },
  --[[jumps_intro = {
    "Robert discovers that there is more than one room to this building.",
    "Poor Robert.",
    "Why don't you help Robert escape. Again.",
    "Use the up button to jump.",
  },
  jumps_exit = {
    "Good job. Robert has escaped. Again.",
  },]]
  twoholes_mid = {
    "Robert finds himself back in the room he just left.",
    "With Robert.",
    "Robert finds this very confusing indeed.",
    "Poor Robert.",
    "It looks like Robert will have to escape again. With himself.",
    "Perhaps he shouldn't get in his own way.",
  },
  first_time = {
    "Robert didn't escape in time.",
    "This caused Robert's head to explode.",
    "Poor Robert.",
    "Try moving faster.",
  },
  first_paradox = {
    "Robert got in his own way.",
    "This caused Robert's head to explode.",
    "Poor Robert.",
    "Try being more careful.",
  },
  reversable = {
    "Robert likes his new-found skill of time travel.",
    "Despite it, sometimes Robert might still get stuck.",
    "If you need to, press X to return to a previous Robert.",
    "What happens to the current Robert?",
    "Nobody really knows.",
    "Robert tries not to think about it.",
  },
}

local rend -- clev.UIRoot:Render
local tick -- clev.tick_loop

local revrembox = CreateFrame("Frame")
local revremsigil = CreateFrame("Text", revrembox)
local revremsprite = CreateFrame("Sprite", revrembox)
local revremoverlay = CreateFrame("Text", revremsprite)
revremoverlay:SetText("X")
revremoverlay:SetPoint("CENTER", revremsprite, "CENTER")
revremoverlay:SetColor(1, 0, 0)
revremoverlay:SetSize(60)
revrembox:SetBackgroundColor(0, 0, 0)
revremsprite:SetTexture("robert")
revremsprite:SetPoint("CENTER", UIParent, "BOTTOMRIGHT", -70, -70)
revremsprite:Hide()
revremsigil:SetText("X = undo")
revremsigil:SetSize(60)
revremsigil:SetPoint(1, 0.5, revremsprite, 0, 0.5)
revremsigil:SetColor(1, 1, 1)
revrembox:SetPoint("TOPLEFT", revremsigil, "TOPLEFT", -20, -15)
revrembox:SetPoint("BOTTOM", revremsigil, "BOTTOM", nil, 15)
revrembox:SetPoint("RIGHT", revremsigil, "RIGHT", 20, nil)


local text_bg = CreateFrame("Frame")
local text_fg = CreateFrame("Frame", text_bg)
local text = CreateFrame("Text_Multiline", text_fg)
local text_butan = CreateFrame("Text", text_fg)
text:SetPoint("TOPLEFT", text_fg, "TOPLEFT", 10, 10)
text:SetPoint("RIGHT", text_fg, "RIGHT", -10, nil)
text:SetHeight(1000)
text:SetColor(0, 0, 0)
text_fg:SetPoint("CENTER", UIParent, "CENTER", 0, 300)
text_fg:SetWidth(500)
text_fg:SetHeight(100)
text_fg:SetBackgroundColor(0.8, 0.8, 0.9)
text_bg:SetPoint("TOPLEFT", text_fg, "TOPLEFT", -10, -10)
text_bg:SetPoint("BOTTOMRIGHT", text_fg, "BOTTOMRIGHT", 10, 10)
text_bg:SetBackgroundColor(0.2, 0.2, 0.3)
text_bg:Hide()
text_butan:SetPoint("BOTTOMRIGHT", text_fg, "BOTTOMRIGHT", -10, -10)
text_butan:SetText("Press space to continue.")
text_butan:SetSize(20)



local function play_text(canned)
  local ticktemp = tick
  tick = nil
  
  text_bg:Show()

  for _, v in pairs(canned) do
    text:SetText(v)
    coroutine.yield()
    while not WasKeyPressed("enter") and not WasKeyPressed("space") and not WasKeyPressed(" ") do
      coroutine.yield()
    end
  end
  
  tick = ticktemp
  text_bg:Hide()
end



local function run_level(lev)
  local current_phase = 1
  local spawned_played = false
  local mid_played = false
  
  local traces = {}
  
  while current_phase <= lev.phases do
    assert(lev.name)
    assert(lev.phases)
    local cl = runuifile("level.lua", lev.name, traces, lev.pos, lev.phases)
    
    local message
    
    cl.message = function (message_in) message = message_in coroutine.yield() --[[ this yield is so we handle each message individually - we won't actually yield again so this doesn't cause framerate hitches, classy no ]] end
    
    rend = function () cl.UIRoot:Render() end
    tick = function (...) cl.tick_loop(...) end
    
    while true do
      message = nil
      while not message do
        coroutine.yield()
      end
      
      if message == "player_spawned" then
        if textses[lev.name .. "_intro"] and not spawned_played then
          spawned_played = true
          play_text(textses[lev.name .. "_intro"])
        end
        
        if current_phase > 1 and textses[lev.name .. "_mid"] and not mid_played then
          mid_played = true
          play_text(textses[lev.name .. "_mid"])
        end
      elseif message[1] == "splat" then
        traces = message[2]
        if not core_segments.timedeath then
          core_segments.timedeath = true
          play_text(textses["first_time"])
        elseif current_phase > 1 and not core_segments.reversabled then
          core_segments.reversabled = true
          play_text(textses["reversable"])
        end
        break
      elseif message[1] == "whoops" then
        if not core_segments.paradoxdeath then
          core_segments.paradoxdeath = true
          play_text(textses["first_paradox"])
        elseif current_phase > 1 and not core_segments.reversabled then
          core_segments.reversabled = true
          play_text(textses["reversable"])
        else
          play_text({"Boom!"})
        end
        break
      elseif message[1] == "yay" then
        current_phase = current_phase + 1
        traces = message[2]
        
        if current_phase > lev.phases and textses[lev.name .. "_exit"] then
          play_text(textses[lev.name .. "_exit"])
        end
        break
      elseif message[1] == "reverse" then
        current_phase = #message[2] + 1
        traces = message[2]
        break
      elseif message == "restart" then
        current_phase = 1
        traces = {}
        break
      else
        assert(false)
      end
    end
    
    cl.UIRoot:Detach()
  end
end


local logic


if levoverride then
  logic = coroutine.wrap(function()
    while true do
      run_level({name = levoverride, phases = 1000})
    end
  end)
else
  logic = coroutine.wrap(function()
    for i = (firstlev or 1), #core_levels do
      run_level(core_levels[i])
      core_segments[core_levels[i].name] = true
      persistence.save()
    end
    
    GlorpController("exit_game")
  end)
end

function tick_loop(...)
  logic()
  if tick then tick(...) end
end
function render()
  if rend then rend() end
end
