
ShowMouseCursor(true)

core_segments = persistence.load("segments")
print("what what", core_segments)
if not core_segments.toplev then core_segments.toplev = 1 end

core_levels = {
  --{name = "simplepath", phases = 1}, -- very first "run to the door"
  {name = "jumps", phases = 1}, -- "here is how you jump"
  {name = "twoholes", phases = 2}, -- pulser intro level, two holes with pulsers
  {name = "underpass", phases = 2}, -- drop down before the third pulser so your clone can go over the top
  {name = "fall", phases = 3}, -- fall to the far left and far right, then snake through big pulsers
  
  {name = "button_tutorial", phases = 1}, -- buttons
  {name = "branch", phases = 2}, -- buttons and branching
  {name = "butan", phases = 2}, -- button level that tricks you into going the wrong way first, training the "undo" button
  {name = "delays", phases = 3}, -- delay waiting for other roberts to go through
  {name = "builder", phases = 3}, -- build a bridge from below
  
  {name = "blinker_intro", phases = 6}, -- intro to blinkers
  {name = "doors", phases = 6}, -- wacky six doors, can probably be made harder?
  {name = "maize", phases = 4}, -- the maze I made with blinkers
  
  {name = "boxes", phases = 3}, -- the level with stacked boxes where the 2nd clone has to make a jump for the 3rd
  {name = "stone", phases = 2}, -- trigger the middle pulser for the second clone
  {name = "staircase", phases = 4}, -- create a staircase with several clones (semi-broken)
  
  {name = "jumpon", phases = 2},  -- jump on yourself
  {name = "multij", phases = 3},  -- jump on yourself
  
  {name = "tutton_intro", phases = 2}, -- intro to tuttons
  {name = "bridge", phases = 4}, -- pass through the same bridge two different ways "simultaneously"
  {name = "tb_intersect", phases = 5}, -- tutton/button intersection
  -- TODO: yet more jump on yourself
  
  
  --{name = "maize_hard", phases = 4},  -- the accidental harder version with jumping on yourself
  
  --{name = "doordelay", phases = 3}, -- intro to delaying your actions, wait for long doors to move up, currently doesn't work
}

local tex = CreateFrame("Text_Multiline")
tex:SetPoint("TOPRIGHT", UIParent, "TOPRIGHT", -20, 50)
tex:SetPoint("LEFT", UIParent, "LEFT", 250, nil)
tex:SetHeight(1000)
tex:SetText(
[[This is a puzzle game.

It's a puzzle game produced over a period of a week, as I struggled valiantly to understand the concepts that my own game was based on. There are many devices in this game that may or may not be interesting, and many attempts at making puzzles that are challenging.

Some of them might be . . . shall we say . . . over-challenging. Some may not be in sensible places in the ordering. The game may get very very hard unexpectedly, followed by getting very, very easy.

The game does not enforce playing levels in order. It's recommended, but if you can't beat a level, feel free to escape to the main menu and skip it. Every few levels, the game will get easy again as it introduces a new puzzle component, so just skip ahead until you find something explained properly. The game will keep track of which levels you've beat, and which you haven't.]])



local cpt

local pointer = CreateFrame("Text")
pointer:SetText(">")
pointer:SetColor(1, 1, 1)

local spots = {}

local function resynch_pointer()
  pointer:SetPoint(1, 0.5, spots[cpt], 0, 0.5, -3, 0)
end


local found_next = false

local anchor = CreateFrame("Frame")
anchor:SetPoint("BOTTOMLEFT", UIParent, "TOPLEFT", 50, 50)
for i = 1, #core_levels do
  local but = CreateFrame("Button")
  local ite = CreateFrame("Text", but)
  ite:SetPoint("TOPLEFT", anchor, "BOTTOMLEFT", 0, 5)
  local name = core_levels[i].name
  ite:SetText(name)
  
  if core_segments[name] then
    ite:SetColor(0.5, 0.5, 0.8)
  else
    if found_next then
      ite:SetColor(0.2, 0.2, 0.2)
    else
      ite:SetColor(1, 1, 1)
      found_next = true
      cpt = i
    end
  end
  
  table.insert(spots, ite)
  function but:Click()
    cpt = i
    resynch_pointer()
  end
  anchor = ite
end

if not cpt then cpt = 1 end


resynch_pointer()



function menu.ok_button:Click()
  GlorpController("start_game", nil, cpt, core_levels, core_segments)
end

menu.ok_text:SetPoint("CENTER", UIParent, "CENTER", 0, 200)
menu.ok_text:SetText("Start")

menu.exit_text:SetPoint("CENTER", UIParent, "CENTER", 0, 300)

menu.ok_text:SetPoint(0.5, nil, tex, 0.5, nil)
menu.exit_text:SetPoint(0.5, nil, tex, 0.5, nil)
