
local _G = _G -- hmmm

function scaffold_init()

local orig_g = _G

local world = setmetatable({}, {__index = _G})
world._G = world
setfenv(1, world)

local lineray = {}
local dynamic_lines = {}

local function GetCube(x, y)
  if not x and not y then return dynamic_lines end
  
  if not lineray[x] then
    lineray[x] = {}
  end
  
  if not lineray[x][y] then
    lineray[x][y] = {}
  end
  
  return lineray[x][y]
end

local function MungeLine(sx, sy, ex, ey, downonly)
  local tabby = {sx, sy, ex, ey}
  
  local tsx = math.min(sx, ex)
  local tsy = math.min(sy, ey)
  
  local tex = math.max(sx, ex)
  local tey = math.max(sy, ey)
  
  tabby.x = (sx + ex) / 2
  tabby.y = (sy + ey) / 2
  
  local dx, dy = ex - sx, ey - sy
  local len = math.sqrt(dx * dx + dy * dy)
  
  tabby.hl = len / 2
  tabby.lx, tabby.ly = dx / len, dy / len
  
  tabby.downonly = downonly

  return tabby, tsx, tsy, tex, tey
end

function InsertDynamicLine(lin)
  dynamic_lines[lin] = MungeLine(lin.sx, lin.sy, lin.ex, lin.ey, lin.downonly)
end
function RemoveDynamicLine(lin)
  dynamic_lines[lin] = nil
end

function InsertLine(sx, sy, ex, ey, downonly)
  local tabby, tsx, tsy, tex, tey = MungeLine(sx, sy, ex, ey, downonly)
  
  tsx, tsy, tex, tey = math.floor(tsx), math.floor(tsy), math.floor(tex), math.floor(tey)
  
  for tx = tsx, tex do
    for ty = tsy, tey do
      table.insert(GetCube(tx, ty), tabby)
    end
  end
end
function GetLines()
  local acu = {}
  for _, v in pairs(lineray) do
    for _, i in pairs(v) do
      for _, d in pairs(i) do
        acu[d] = true
      end
    end
  end
  
  local rv = {}
  for k, _ in pairs(acu) do
    table.insert(rv, k)
  end
  
  return rv
end

local fabs = math.abs
-- who the fuck knows
-- http://www.gamasutra.com/features/19991018/Gomez_6.htm
--assert(intersect(0.8, 0.8, 0.4, 0.4, 1, 0, 1.0, 1.0, 0.5))
local function intersect(bpx, bpy, bex, bey, lx, ly, midx, midy, hl)
  --print(bpx, bpy, bex, bey, "   ", lx, ly, midx, midy, hl)
  
  local tx, ty = bpx - midx, bpy - midy
  
  if fabs(tx) > bex + hl * fabs(lx) then return false end
  if fabs(ty) > bey + hl * fabs(ly) then return false end
  
  if fabs(tx * ly - ty * lx) > bex * fabs(ly) + bey * fabs(lx) then return false end
  
  return true
end

local function line_pushback(x1, y1, x2, y2, xp1, yp1, xp2, yp2)
  local inside = 0      -- for now, this is disabled
  
  -- the line equations will be put in the form
  -- x(y2-y1)+y(x1-x2)-x1*y2+x2*y1=0
  --     A        B        C
  local a1,b1,c1,a2,b2,c2,r1,r2;

  a1=y2-y1;
  b1=x1-x2;
  c1=-x1*y2+x2*y1;

  if (yp1<yp2 or (yp1==yp2 and xp1>xp2)) then    -- use only increasing functions
    r1=yp1; yp1=yp2; yp2=r1;        -- swap endpoints if wrong order
    r1=xp1; xp1=xp2; xp2=r1;
  end

  local xdiff,ydiff;
--[[  int32_t xdiff=abs(xp1-xp2),ydiff=yp1-yp2;
  if (xdiff>=ydiff)                              // increment the endpoints
    if (xp2<xp1) { xp2--; xp1++; }
    else { xp2++; xp1--; }

  if (xdiff<=ydiff)
  {
    yp1++;
    yp2--;
  } ]]


  r1=xp1*a1+yp1*b1+c1;
  r2=xp2*a1+yp2*b1+c1;

  if ((r1 * r2) <= 0) then           -- signs must be different to intersect
    a2=yp2-yp1;
    b2=xp1-xp2;
    c2=-xp1*yp2+xp2*yp1;
    r1=x1*a2+y1*b2+c2;
    r2=x2*a2+y2*b2+c2;

    if ((r1 * r2) <= 0) then
      if ( inside==0 or r2==0 or
          xp1<xp2 and r2*inside>0 or
          xp1>=xp2 and r2*inside<0
          ) then
	local ae, bd = a1*b2, b1*a2;
	if (ae~=bd) then         -- co-linear returns 0
	  x2=(b1*c2-b2*c1)/(ae-bd);
	  y2=(a1*c2-a2*c1)/(bd-ae);
	  xdiff=fabs(x2-x1);
	  ydiff=fabs(y2-y1);
          
          -- push the intersection back a small and strange distance
          if (y2>y1) then
            y2 = math.max(y2 - 0.00071, y1);
          else
            y2 = math.min(y2 + 0.00071, y1);
          end
          if (x2>x1) then
            x2 = math.max(x2 - 0.00071, x1);
          else
            x2 = math.min(x2 + 0.00071, x1);
          end
          
          return x2, y2, true;
	end
      end
    end
  end
  return x2, y2, false;
end

local function line_pushy(x1, x2, xd, yd, xp1, yp1, xp2, yp2, ainter, inv)
  --print(x1, x2, xd, yd, xp1, yp1, xp2, yp2, ainter, inv)
  
  local txd, tyd, int = xd, yd
  if inv then txd, tyd = -txd, -tyd end
  txd, tyd, int = line_pushback(x1, x2, x1 + txd, x2 + tyd, xp1, yp1, xp2, yp2)
  
  if not int then
    return xd, yd, ainter
  else
    txd, tyd = txd - x1, tyd - x2
    if inv then txd, tyd = -txd, -tyd end
    return txd, tyd, int
  end
end

--[[
parameters for the following function:

box X
box Y
box extent X (1/2 of width)
box extent Y (1/2 of height)
box delta x
box delta y
box step delta x
box step delta y
step count
line x (direction, normalized)
line y (direction, normalized)
midpoint x of line
midpoint y of line
half-line length
line start x
line start y
line end x
line end y
semisolid]]

local failintersect = {}

local function pushback(bx, by, bex, bey, bdx, bdy, bsdx, bsdy, sct, lx, ly, midx, midy, hl, lsx, lsy, lex, ley, semisolid)
  local sdx, sdy, inter = bdx, bdy, false
  
  --print("lolwut", bx, by, bex, bey, lx, ly, midx, midy, hl, "    ", sdx, sdy)
  local intersected = intersect(bx, by, bex, bey, lx, ly, midx, midy, hl)
  if semisolid and intersected then return sdx, sdy, inter end
  if intersected then
    print("intersect failed", bx, by, bex, bey)
  end
  assert(not intersected)
  
  --[[  -- siiiigh
  if intersect(bx, by, bex, bey, lx, ly, midx, midy, hl) then
    -- argh intersect failure let's bump things around a pray a bit
    local dx, dy = {1, 1, 1, 0, 0, -1, -1, -1}, {1, 0, -1, 1, -1, 1, 0, -1}
    local solved = false
    for i = 1, 8 do
      if not intersect(bx + dx[i], by + dy[i], bex, bey, lx, ly, midx, midy, hl) then
        solved = i
        break
      end
    end
    
    assert(solved)
    
    bx, by = bx + dx[i], by + dy[i]
  end]]
  
  for i = 1, sct do
    if intersect(bx + bsdx * i, by + bsdy * i, bex, bey, lx, ly, midx, midy, hl) then
      -- welp, we intersected, so do our more expensive sweep tests
      
      --sdx, sdy = sdx * 1.01, sdy * 1.01         -- guard very slightly against edge conditions
      
      -- bottom-left point versus line
      sdx, sdy, inter = line_pushy(bx - bex, by + bey, sdx, sdy, lsx, lsy, lex, ley, inter)
      -- bottom-right point versus line
      sdx, sdy, inter = line_pushy(bx + bex, by + bey, sdx, sdy, lsx, lsy, lex, ley, inter)
      -- top-left point versus line
      sdx, sdy, inter = line_pushy(bx - bex, by - bey, sdx, sdy, lsx, lsy, lex, ley, inter)
      -- top-right point versus line
      sdx, sdy, inter = line_pushy(bx + bex, by - bey, sdx, sdy, lsx, lsy, lex, ley, inter)
      
      -- now we do the painful part
      -- line start point vs bottom, right, top, left
      sdx, sdy, inter = line_pushy(lsx, lsy, sdx, sdy, bx - bex, by + bey, bx + bex, by + bey, inter, true)
      sdx, sdy, inter = line_pushy(lsx, lsy, sdx, sdy, bx + bex, by + bey, bx + bex, by - bey, inter, true)
      sdx, sdy, inter = line_pushy(lsx, lsy, sdx, sdy, bx - bex, by - bey, bx + bex, by - bey, inter, true)
      sdx, sdy, inter = line_pushy(lsx, lsy, sdx, sdy, bx - bex, by + bey, bx - bex, by - bey, inter, true)
      
      -- line end point vs bottom, right, top, left
      sdx, sdy, inter = line_pushy(lex, ley, sdx, sdy, bx - bex, by + bey, bx + bex, by + bey, inter, true)
      sdx, sdy, inter = line_pushy(lex, ley, sdx, sdy, bx + bex, by + bey, bx + bex, by - bey, inter, true)
      sdx, sdy, inter = line_pushy(lex, ley, sdx, sdy, bx - bex, by - bey, bx + bex, by - bey, inter, true)
      sdx, sdy, inter = line_pushy(lex, ley, sdx, sdy, bx - bex, by + bey, bx - bex, by - bey, inter, true)
    end
  end
  
  --print("trying", bx + sdx, by + sdy, bex, bey, lx, ly, midx, midy, hl, "   ", sdx, sdy)
  while intersect(bx + sdx, by + sdy, bex, bey, lx, ly, midx, midy, hl) do
    print("dintersecting")
    sdx, sdy = approach(sdx, 0, 0.1), approach(sdy, 0, 0.1)
    print("welp")
    
    print(sdx, sdy, inter)  -- if inter is false, we did the fallover case listed above
    print(bx, by, bex, bey, bdx, bdy, bsdx, bsdy, sct, lx, ly, midx, midy, hl, lsx, lsy, lex, ley)
  end
  
  assert(not intersect(bx + sdx, by + sdy, bex, bey, lx, ly, midx, midy, hl))
  
  if (sdx ~= bdx or sdy ~= bdy) and not inter then inter = failintersect end
  
  return sdx, sdy, inter
end



local function split(w, h, xv, yv)
  local x = math.ceil(math.max(math.abs(xv / w), math.abs(yv / h)))
  if not (x > 0) then print(w, h, xv, yv) end
  assert(x > 0)
  return x
end

local ltest = 0
local function foreground_intersect(bx, by, bex, bey, bdx, bdy, bsdx, bsdy, sct)
  local tsx = math.min(bx - bex, bx - bex + bdx)
  local tsy = math.min(by - bey, by - bey + bdy)
  
  local tex = math.max(bx + bex, bx + bex + bdx)
  local tey = math.max(by + bey, by + bey + bdy)
  
  tsx, tsy, tex, tey = math.floor(tsx), math.floor(tsy), math.floor(tex), math.floor(tey)
  --print("flibounds", tsx, tsy, tex, tey, "   ", bx, by, bex, bey, bdx, bdy)
  
  ltest = ltest + 1
  assert(ltest < 2000000000)
  
  local inter = nil
  local tintr
  
  local upwards = (bdy < 0)
  
  for tx = tsx, tex do
    for ty = tsy, tey do
      --print("doing chunk", tx, ty)
      for _, v in pairs(GetCube(tx, ty)) do
        if v.tested ~= ltest and (not v.downonly or not upwards) then
          bdx, bdy, tinter = pushback(bx, by, bex, bey, bdx, bdy, bsdx, bsdy, sct, v.lx, v.ly, v.x, v.y, v.hl, v[1], v[2], v[3], v[4], v.downonly)
          v.tested = ltest
          if bdx == 0 and bdy == 0 then return 0, 0, v end
          if tinter then
            inter = v
            sct = split(bex * 2, bey * 2, bdx, bdy)
            bsdx, bsdy = bdx / sct, bdy / sct
          end
        end
      end
    end
  end
  
  for _, v in pairs(dynamic_lines) do
    bdx, bdy, tinter = pushback(bx, by, bex, bey, bdx, bdy, bsdx, bsdy, sct, v.lx, v.ly, v.x, v.y, v.hl, v[1], v[2], v[3], v[4], v.downonly)
    if bdx == 0 and bdy == 0 then return 0, 0, v end
    if tinter then
      inter = v
      sct = split(bex * 2, bey * 2, bdx, bdy)
      bsdx, bsdy = bdx / sct, bdy / sct
    end
  end
  
  return bdx, bdy, inter
end

function is_valid_location(x, y, wid, hei)
  ltest = ltest + 1
  assert(ltest < 2000000000)
  
  for tx = math.floor(x - wid / 2), math.ceil(x + wid / 2) do
    for ty = math.floor(y - hei / 2), math.ceil(y + hei / 2) do
      --print("doing chunk", tx, ty)
      for _, v in ipairs(GetCube(tx, ty)) do
        if v.tested ~= ltest and not v.downonly then
          if intersect(x, y, wid / 2, hei / 2, v.lx, v.ly, v.x, v.y, v.hl) then
            return false
          end
        end
      end
    end
  end
  
  for _, v in pairs(dynamic_lines) do
    if not v.downonly then
      if intersect(x, y, wid / 2, hei / 2, v.lx, v.ly, v.x, v.y, v.hl) then
        return false
      end
    end
  end
  
  return true
end

--[[
function recombine(orig, new)
  if math.abs(orig - new) < 0.0001 then
    return orig
  else
    return new
  end
end

function try_move_part(x, y, xv, yv, top)
  local tx, ty, pbx, imp = foreground_intersect(x, y, x + xv, y + yv, top)
  
  return recombine(xv, tx - x), recombine(yv, ty - y), pbx, imp
end]]

function try_move(self, x, y, xv, yv)
  assert(self, x, y, xv, yv)
  
  --print("STRIX", x, y, xv, yv)
  if xv == 0 and yv == 0 then
    --print("STOON ZERO")
    return 0, 0, nil
  end
  
  local sct = split(self.width, self.height, xv, yv)
  
  --print("flinter", x, y, xv, yv, sct)
  local nx, ny, ni = foreground_intersect(x, y, self.width / 2, self.height / 2, xv, yv, xv / sct, yv / sct, sct)
  
  if ni then
    --print("trim", xv, yv, nx, ny)
    local tnx, tny, tni = try_move(self, x, y, nx, ny)
    if tni then
      --print("redo")
      nx, ny, ni = tnx, tny, tni
    end
    --print("trimdone")
  end
  
  --print("ARGY", x, y, xv, yv, nx, ny, ni)
  foreground_intersect(x + nx, y + ny, self.width / 2, self.height / 2, 0, 1, 0, 1, 1)
  --print("STOON")
  return nx, ny, ni
end

local function climbable(wall)
  local dx = wall[1] - wall[3]
  local dy = wall[2] - wall[4]
  local slope = math.abs(dy / dx)
  return slope < 1
end




function standard_tick(self)
  --self:attach(nil)
  
  --[[if not self.freefall and self.player then
    local xt, yt = try_move(self, self.x, self.y - 0.01, 0, 0.02)
    self.y = self.y - 0.01 + yt
  end   -- make sure we're not falling through the floor]]
  
  --print(self.x, self.y, self.xvel, self.yvel, self.xacel, self.yacel, self.freefall)
  -- first let's move the guy acording to his physics
  if self.freefall then
    self.yacel = self.yacel + 0.012 * self.gravity
  end
  self.xvel = self.xvel + self.xacel
  self.yvel = self.yvel + self.yacel
  self.xacel, self.yacel = 0, 0
  
  --if self.verbose then print(self.xvel, self.yvel) end
  
  local xv, yv = self.xvel, self.yvel
  local old_xv, old_yv = xv, yv
  
  --print("xv", self.xvel)
  
  -- check to see if this advancement causes him to collide with objects
  if xv ~= 0 or yv ~= 0 then
    local impflags
    xv, yv, _, impflags = try_move(self, self.x, self.y, xv, yv)
    
    --[[if impflags == "l" then
      xv, yv = try_move(self, self.x, self.y, old_xv + 0.01, old_yv)
    elseif impflags == "r" then
      xv, yv = try_move(self, self.x, self.y, old_xv - 0.01, old_yv)
    end]]
    
    self.xvel, self.yvel = xv, yv
    self.x, self.y = self.x + xv, self.y + yv
    
    --if (h && stoppable()) return BLOCKED_LEFT|BLOCKED_RIGHT;
    
    if xv ~= old_xv or yv ~= old_yv then        -- he collided with something
      --print("collide")
      if self.freefall then      -- was he in freefall?
        local old_fall_yv = old_yv - yv
        local _, fall_yv = try_move(self, self.x, self.y, 0, old_fall_yv)   -- see if we can, in fact, keep moving vertically
        
        -- accumulate vertical movement
        self.yvel = self.yvel + fall_yv
        self.y = self.y + fall_yv
        
        if old_yv > 0 and fall_yv < old_fall_yv then    -- we were trying to fall, but we hit the ground
        
          self.state = "end_run_jump";
          
          self.yvel = -old_yv * (self.bouncefactor or 0)
          if math.abs(self.yvel) <= (self.bouncelimit or 0) then
            self.yvel = 0
            self.freefall = false
            self.gravity = 0
          end
        else
        
          
          -- we were not falling/hitting ground, set flags
          --[=[ -- set blocked flags
          if old_vy ~= 0 then
            local testx = (old_vx < 0) and -0.0011 or 0.0011      -- see if we were stopped left/right or just up/down
            testx = try_move(self, x, y, testx, 0, true, true)
            --[[
            if math.abs(testx) < 0.001 then -- blocked left/right, set flag
	    {
	      if (old_vx<0)
	        blocked|=BLOCKED_LEFT;
	      else
	        blocked|=BLOCKED_RIGHT;
	    }
	    else if (old_vy<0)
	      blocked|=BLOCKED_UP;
	    else if (old_vy>0)
	      blocked|=BLOCKED_DOWN;]]
          elseif old_vx < 0
            blocked|=BLOCKED_LEFT;
	  else
            blocked|=BLOCKED_RIGHT;
          ]=]
        end
        
        
        -- alright, see if we can keep moving horizontally
        local old_fall_xv = old_xv - xv
        local fall_xv, _ = try_move(self, self.x, self.y, old_fall_xv, 0)
        
        -- accumulate otherwise-lost horizontal movement
        self.xvel = self.xvel + fall_xv
        self.x = self.x + fall_xv
        
        --print(fall_xv, fall_yv, old_fall_xv, old_fall_yv, self.x, self.y)
      end
      
      if not self.freefall then
        -- we were not in freefall
        
        -- climb slope code here
        -- So here's what we're doing. First, we step up a tiny bit, on the assumption that we might have a tiny geometry hiccup. Then we slide up diagonally whatever our remaining X direction is. If we hit something, we try sliding directly to the right whatever we have left, in case we're in a tight corridor and we clipped the ceiling. Then, we drop back down up to however much we went up.
        
        local heightened = 0
        
        --print("slopey")
        
        local slope_x, slope_y = self.x, self.y -- our working slope values
        local slope_dx, slope_dy = try_move(self, slope_x, slope_y, 0, -0.05) -- try to move up to step over the jutting polygon line
        heightened = heightened + slope_dy
        slope_x, slope_y = slope_x + slope_dx, slope_y + slope_dy
        --print("jut", slope_dx, slope_dy)
        
        local total_sideways_available = old_xv - self.xvel
        slope_dx, slope_dy = try_move(self, slope_x, slope_y, total_sideways_available, -math.abs(total_sideways_available))  -- 45 degree slope
        heightened = heightened + slope_dy
        total_sideways_available = total_sideways_available - slope_dx
        slope_x, slope_y = slope_x + slope_dx, slope_y + slope_dy
        --print("45", slope_dx, slope_dy)
        
        -- straight to the side, if we've got move left
        if total_sideways_available ~= 0 then
          slope_dx, slope_dy = try_move(self, slope_x, slope_y, total_sideways_available, 0)
          total_sideways_available = total_sideways_available - slope_dx
          slope_x, slope_y = slope_x + slope_dx, slope_y + slope_dy
          --print("side", slope_dx, slope_dy)
        end
                  
        -- back down to the ground
        local targ
        slope_dx, slope_dy, targ = try_move(self, slope_x, slope_y, 0, -heightened)
        slope_x, slope_y = slope_x + slope_dx, slope_y + slope_dy
        --print("down", slope_dx, slope_dy)
        
        local x_movement = slope_x - self.x
        --print("hmm", climb_x_movement, targ, targ and climbable(targ))
        
        --print("moved", slope_x - self.x, slope_y - self.y, math.abs(x_movement) > 0.0011, (not targ or climbable(targ)))
        if math.abs(x_movement) > 0.0011 and (not targ or climbable(targ) or true) then      -- did we get further? at some point, tweak this to deal with steep walls
          --blocked=blocked&(~(BLOCKED_LEFT|BLOCKED_RIGHT));
          self.xvel = self.xvel + x_movement
          
          self.yvel = slope_y - self.y
          self.x, self.y = slope_x, slope_y
          
        else
          self.state = "stopped"
          --[[	  if (old_vx<0)
          blocked|=BLOCKED_LEFT;
	  else
          blocked|=BLOCKED_RIGHT;
	  set_state(stopped);      // nope, musta hit a wall, stop the poor fella
	  x=ox;
	  y=oy;	]]
        end
      end
      
      if math.abs(self.xvel - old_xv) > 0.0001 then       -- we impacted something moving sideways, stop or possibly bounce
        if self.bouncefactor and self.xvel / old_xv < 0.99 then
          self.xvel = -old_xv * self.bouncefactor
          if math.abs(self.xvel) <= (self.bouncelimit or 0) then
            self.xvel = 0
          end
        else
          self.xvel = 0
        end
      end
    end
  end
  
  if not self.freefall then
    -- can we freefall?
    
    local _, dv, imp = try_move(self, self.x, self.y, 0, 0.2)
    if dv > 0.11 then
      --print(dv)
      self.freefall = true      -- free fallin'
      self.gravity = 1
      self.state = "run_jump_fall"
    else
      self.y = self.y + dv      -- merely descending a slope
      self.yvel = dv
      --self:attach(imp)
    end
  end
end

function ground_anchor(entity)
  assert(entity.x)
  assert(entity.y)
  local dx, dy = try_move(entity, entity.x, entity.y, 0, 1)
  entity.x, entity.y = entity.x + dx, entity.y + dy
end

function standard_attach(self, item)
  assert(item == nil or type(item) == "table")
  if self.parent then
    self.parent.children[self] = nil
  end
  
  self.parent = item
  
  if self.parent then
    if not self.parent.children then self.parent.children = {} end
    self.parent.children[self] = true
  end
end

local def_entity = {}
function def_entity:tick()
  if self.think then self:think() end
  if self.coro then self.coro() end
  
  self.default_tick(self)
  
  if self.sprite then
    self.sprite:SetPoint("CENTER", UIParent, "TOPLEFT", self.x, self.y)
    if self.sprite.tick then self.sprite:tick() end
  end
end
def_entity.default_tick = standard_tick
function Entity(x, y)
  return setmetatable({x = x, y = y, xvel = 0, yvel = 0, xacel = 0, yacel = 0, freefall = false, gravity = 0, state = "stopped", direction = -1}, {__index = def_entity})
end


return export_items_ro(world, {"Entity", "InsertLine", "try_move", "ground_anchor", "is_valid_location", "InsertDynamicLine", "RemoveDynamicLine"})

end
