
assert(loadfile("serialization.lua"))()

local _G = _G -- hmmm

function terra_init(tyles, entits)

local world = setmetatable({}, {__index = _G})
world._G = world
setfenv(1, world)


local tile_lib = {}
for k, v in pairs(tyles) do
  tile_lib[k] = v
end

local level_data = {tile_data = {}, entity_data = {}}
local tile_data = level_data.tile_data
local entity_data = level_data.entity_data


do
  local List_params = {}
  
  function List_params:Create()
    gl.NewList(self.listid, "COMPILE")
  end
  function List_params:End()
    gl.EndList()
  end
  
  function List_params:Call()
    gl.CallList(self.listid)
  end
  -- we don't yet support deleting
  
  function List()
    local ite = setmetatable({}, {__index = List_params})
    ite.listid = gl.GenLists(1)
    
    return ite
  end
end



function metalayer(layer)
  local metarows = {}
  if not tile_data[layer] then tile_data[layer] = {} end
  
  return setmetatable({},
    {__newindex = function() assert(false) end,
    __index = function(t, k)
      assert(type(k) == "number")
      if not tile_data[layer][k] then tile_data[layer][k] = {} end
      if not metarows[k] then metarows[k] = setmetatable({},
        {__newindex = function(t, tk, v)
          assert((v == nil) or tile_lib[v])
          assert(type(tk) == "number")
          
          if v == "" then v = nil end
          
          tile_data[layer][k][tk] = v
        end,
        __index = function(t, tk)
          assert(type(tk) == "number")
          return tile_data[layer][k][tk]
        end}
      ) end
      return metarows[k]
    end})
end

function mergedown(from, to)
  if not tile_data[from] then return end
  if not tile_data[to] then tile_data[to] = {} end
  
  for tx, txd in pairs(tile_data[from]) do
    if not tile_data[to][tx] then
      tile_data[to][tx] = {}
    end
    
    for ty, tyd in pairs(txd) do
      tile_data[to][tx][ty] = tyd
    end
    
    tile_data[from][tx] = {}
  end
end
function shiftlayer(lay, dx, dy)
  print("SLAYER")
  local tlay = tile_data[lay]
  
  tile_data[lay] = {}
  for tx, txd in pairs(tlay) do
    tile_data[lay][tx + dx] = {}
    local la = tile_data[lay][tx + dx]
    
    for ty, tyd in pairs(txd) do
      la[ty + dy] = tyd
    end
  end
  print("SLAYED")
end
function eraselayer(lay)
  tile_data[lay] = {}
end

-- select works like this
-- selected squares are lofted into the select layer
-- then they're moved around
-- when deselected, they're jammed back into the main layer
-- terra is not going to handle much besides the existence of the layers

local metalayers = {}
layers = setmetatable({},
  {__newindex = function() assert(false) end,
  __index = function(t, k)
    assert(k == 1 or k == "select")
    if not metalayers[k] then metalayers[k] = metalayer(k) end
    return metalayers[k]
  end})

function scaffoldize(InsertLine)
  for x, l in pairs(tile_data[1]) do
    for y, t in pairs(l) do
      assert(tile_lib[t])
      local til = tile_lib[t]
      
      if #til > 0 then
        for ofs = 1, (til.solids and (til.solids * 2) or (#til - 2)), 2 do
          InsertLine(til[ofs] + x, til[ofs + 1] + y, til[ofs + 2] + x, til[ofs + 3] + y, til.downonly)
        end
        if not til.solids then
          InsertLine(til[#til - 1] + x, til[#til] + y, til[1] + x, til[2] + y, til.downonly)
        end
      end
    end
  end
end

function render()
  gl.Color(1, 1, 1)
  
  for i = 1, 2 do
    local gtx = (i == 1) and "bg" or "tex"
    local texdone = {}
    
    while true do
      local curtex = nil
      
      for pid, plane in pairs(tile_data) do
        if pid == 1 then
          gl.Color(1, 1, 1)
        else
          gl.Color(0.2, 0.2, 0.6)
        end
        
        for x, l in pairs(plane) do
          --if x < xs or x > xe then continue end
          for y, t in pairs(l) do
            --if y < ys or y > ye then continue end
            
            local v = tile_lib[t]
            if v[gtx] and not (curtex and curtex ~= v[gtx]) and not texdone[v[gtx]] then
              if not curtex then
                curtex = v[gtx]
                Texture(v[gtx]):SetTexture()
                gl.Begin("TRIANGLES")
              end
              
              if i == 1 then
                gl.TexCoord(0, 0)
                gl.Vertex(x, y)
                gl.TexCoord(1, 0)
                gl.Vertex(x + 1, y)
                gl.TexCoord(1, 1)
                gl.Vertex(x + 1, y + 1)
                
                gl.TexCoord(0, 0)
                gl.Vertex(x, y)
                gl.TexCoord(0, 1)
                gl.Vertex(x, y + 1)
                gl.TexCoord(1, 1)
                gl.Vertex(x + 1, y + 1)
              else
                for vtx = 3, #v - 2, 2 do
                  gl.TexCoord(v[1], v[2])
                  gl.Vertex(x + v[1], y + v[2])
                  gl.TexCoord(v[vtx], v[vtx + 1])
                  gl.Vertex(x + v[vtx], y + v[vtx + 1])
                  gl.TexCoord(v[vtx + 2], v[vtx + 3])
                  gl.Vertex(x + v[vtx + 2], y + v[vtx + 3])
                end
              end
            end
          end
        end
      end
      
      if curtex then
        gl.End()
        texdone[curtex] = true
      else
        break
      end
    end
  end
  
  SetNoTexture()
end
function render_sprites()
  for _, v in ipairs(entity_data) do
    local ent = entits[v.id]
    assert(ent)
    glutil.RenderCenteredSprite(Texture(ent.tex), v.x, v.y, ent.width, ent.height, ent.r, ent.g, ent.b)
  end
end
local bucket_size = 10

local buckets = {}
function build_buckets()
  assert(#buckets == 0)
  
  local sx = 0
  local sy = 0
  local ex = 0
  local ey = 0
  
  local txl = {}
  
  for pid, plane in pairs(tile_data) do
    for x, l in pairs(plane) do
      sx = math.min(sx, x)
      ex = math.max(ex, x + 1)
      for y, t in pairs(l) do
        sy = math.min(sy, y)
        ey = math.max(ey, y + 1)
        
        if tile_lib[t].tex and not txl[tile_lib[t].tex] then
          txl[tile_lib[t].tex] = Texture(tile_lib[t].tex)
        end
        if tile_lib[t].bg and not txl[tile_lib[t].bg] then
          txl[tile_lib[t].bg] = Texture(tile_lib[t].bg)
        end
      end
    end
  end
  
  sx = math.floor(sx / 10)
  sy = math.floor(sy / 10)
  ex = math.ceil(ex / 10) - 1
  ey = math.ceil(ey / 10) - 1
  for y = sy, ey do
    for x = sx, ex do
      local lst = List()
      lst:Create()
      
      render(x * 10, y * 10, x * 10 + 10, y * 10 + 10)
      
      lst:End()
      
      lst.x = x * 10 + 5
      lst.y = y * 10 + 5
      lst.height = 10
      lst.width = 10
      
      table.insert(buckets, lst)
    end
  end
end
local function collide(one, two)
  return math.abs(two.x - one.x) * 2 <= two.width + one.width and math.abs(two.y - one.y) * 2 <= two.height + one.height
end
function render_buckets()
  if #buckets == 0 then build_buckets() end
  
  --local bd = {x = (sx + ex) / 2, y = (sy + ey) / 2, width = ex - sx, height = ey - sy}
  
  for _, v in pairs(buckets) do
    --if collide(bd, v) then
      v:Call()
    --end
  end
end
  

function entities()
  return entity_data
end
function save()
  return serialization.stringize(level_data)
end
function load(str)
  if not str then return end
  level_data = loadstring("return " .. str)()
  tile_data = level_data.tile_data
  entity_data = level_data.entity_data
  for _, p in pairs(tile_data) do
    for _, k in pairs(p) do
      for _, t in pairs(k) do
        if not tile_lib[t] then print(t) end
        assert(tile_lib[t])
      end
    end
  end
  for _, v in ipairs(entity_data) do
    assert(entits[v.id], "can't find " .. v.id)
  end
end

return export_items_ro(world, {"layers", "scaffoldize", "render", "render_sprites", "save", "load", "entities", "mergedown", "shiftlayer", "eraselayer", "render_buckets"})

end
