
mappieces = {
  ['outside_#'] = {0, 0,   0, 1,   1, 1,   1, 0, tex = "ground"},       -- solid
  ['outside_,'] = {0, 1,   1, 1,   1, 0.5, topl = 1, topr = 0.5, tex = "ground"}, -- empty triangle going up to the right
  ['outside_<'] = {0, 0.5,   0, 1,   1, 1,   1, 0, topl = 0.5, topr = 0, tex = "ground"}, -- full triangle going up to the right
  ['outside_.'] = {1, 1,   0, 1,   0, 0.5, topl = 0.5, topr = 1.0, tex = "ground"}, -- empty triangle going up to the left
  ['outside_>'] = {1, 0.5,   1, 1,   0, 1,   0, 0, topl = 0, topr = 0.5, tex = "ground"}, -- full triangle going up to the left
  ['outside_-'] = {1, 0.5,   1, 1,   0, 1,   0, 0.5, topl = 0.5, topr = 0.5, tex = "ground"}, -- half-height
  
  -- ceiling items
  ['outside_;'] = {0, 0,   0, 1,   1, 0.5,   1, 0, permit = true, tex = "ground"}, -- full triangle going up to the right
  ['outside_:'] = {0, 0,   0, 0.5,   1, 0, permit = true, tex = "ground"}, -- empty triangle going up to the right
  ['outside_\''] = {0, 0,   0, 0.5,   1, 1,   1, 0, permit = true, tex = "ground"}, -- full triangle going up to the left
  ['outside_"'] = {0, 0,   1, 0.5,   1, 0, permit = true, tex = "ground"}, -- empty triangle going up to the left
  ['outside_='] = {1, 0.5,   1, 0,   0, 0,   0, 0.5, permit = true, tex = "ground"}, -- half-height reverse
  
  platformy = {0, 0, 1, 0, 1, 0.1, 0, 0.1, tex = "ground", downonly = true, solids = 1},
  
  [''] = {},
}

mappiece_layout = {
  {'outside_,', 'outside_<', 'outside_#', 'outside_>', 'outside_-', 'outside_.'},
  {'outside_;', 'outside_:', '', 'outside_"', 'outside_=', 'outside_\''},
  {'platformy'}
}


entities = {
  entry = {tex = "tower", width = 2, height = 3, entry = true},
  exit = {tex = "exit", width = 2, height = 3, exit = true},
  robert = {tex = "robert", width = 0.8, height = 1.6},
  
  movewall = {tex = "field", width = 0.5, height = 20, flying = true},
  
  blinker_odd = {tex = "field_stripe", width = 1, height = 1, flying = true, grid = true, r = 1, g = 1, b = 1},
  blinker_even = {tex = "field_stripe", width = 1, height = 1, flying = true, grid = true, r = 0.5, g = 0.5, b = 0.5},
}

entity_layout = {
  {"entry", "exit"},
  {"movewall", "blinker_odd", "blinker_even"},
  {},
  {},
  {},
  {},
  {},
}

local tbtemp = {}
local colors = {"b", "g", "gb", "r", "rb", "rg", "rgb"}
for _, v in ipairs(colors) do
  local r, g, b = v:find("r") and 1 or 0, v:find("g") and 1 or 0, v:find("b") and 1 or 0
  entities["button_" .. v] = {tex = "button", width = 1.5, height = 1.5, flying = true, r = r, g = g, b = b}
  entities["tbutton_" .. v] = {tex = "tbutton", width = 1.5, height = 1.5, flying = true, r = r, g = g, b = b}
  entities["wallon_" .. v] = {tex = "field", width = 1, height = 1, grid = true, flying = true, r = r, g = g, b = b}
  entities["walloff_" .. v] = {tex = "field", width = 1, height = 1, grid = true, flying = true, r = r / 2, g = g / 2, b = b / 2}
  table.insert(entity_layout[4], "button_" .. v)
  table.insert(tbtemp, "tbutton_" .. v)
  table.insert(entity_layout[5], "wallon_" .. v)
  table.insert(entity_layout[6], "walloff_" .. v)
end
for _, v in ipairs(tbtemp) do
  table.insert(entity_layout[4], v)
end

for y = 1, 6 do
  local ro = {}
  for x = 1, 6 do
    entities["field" .. x .. y] = {tex = "field", width = x, height = y, grid = true, flying = true},
    table.insert(ro, "field" .. x .. y)
  end
  table.insert(entity_layout, ro)
end
