
loadfile("scaffold.lua")()
loadfile("terra.lua")()
loadfile("worldparams.lua")()

local gameworld = CreateFrame("Frame")
gameworld:SetAllPoints()

local xcenter, ycenter = 0, 0


local terra = terra_init(mappieces, entities)
terra.load(io.snatch(override_level or "machaira.lev.lua"))
local terraframe = CreateFrame("Frame", gameworld)
function terraframe:Draw()
  terra.render()
end

local scaffold = scaffold_init()
terra.scaffoldize(scaffold.InsertLine)


local player
local monsters = {}
local mstabs = {}
local stabs = {}
local death = {}

local function collide(one, two)
  return math.abs(two.x - one.x) * 2 <= two.width + one.width and math.abs(two.y - one.y) * 2 <= two.height + one.height
end

local function corpsify(target)
  target.bouncefactor = 0.55
  target.bouncelimit = 0.01
  target.gravity = 1
  target.freefall = true
  target.dead = true
  
  target.think = function ()
    if not target.freefall then
      target.xvel = approach(target.xvel, 0, 0.01)
    end
  end
  target.coro = nil
end

local frem = CreateFrame("Frame")
frem:SetPoint("TOPLEFT", UIParent, "TOPLEFT", 20, 0)
frem:SetHeight(20)

local taxt = {}

local function notify_item(txt)
  local lest = taxt[#taxt]
  if not lest then lest = frem end
  
  local titem = CreateFrame("Text")
  titem:SetPoint("TOPLEFT", lest, "BOTTOMLEFT", 0, 5)
  titem:SetColor(1.0, 0.5, 0.5)
  titem:SetText(txt)
  titem:SetSize(20)
  
  titem.origin = os.time()
  
  table.insert(taxt, titem)
end

monsters[{tick = function ()
  while taxt[1] and taxt[1].origin + 5 < os.time() do
    taxt[1]:Detach()
    table.remove(taxt, 1)
    if taxt[1] then
      taxt[1]:SetPoint("TOPLEFT", frem, "BOTTOMLEFT", 0, 5)
    end
  end
end}] = true


--[[ #####################################
                                 MONSTERS, CREATION
#######################################]]

function NewMonster(monster)
  local ent = scaffold.Entity(monster.x, monster.y)
  local self = ent
  
  ent.width, ent.height = entities[monster.id].width, entities[monster.id].height
  ent.sprite = CreateFrame("Sprite", gameworld)
  ent.sprite:SetTexture(entities[monster.id].tex)
  ent.sprite:SetWidth(ent.width)
  ent.sprite:SetHeight(ent.height)

  if not entities[monster.id].flying and not entities[monster.id].not_real then
    scaffold.ground_anchor(ent)
  end
  
  ent.prototype = entities[monster.id]
  ent.damageable = ent.prototype.damageable
  ent.health = ent.prototype.health
  
  local function approach_to(dist)
    while true do
      local rdist = dist
      if self.x < player.x then rdist = -rdist end
      local tarjet = player.x + rdist
      if math.abs(self.x - tarjet) < 0.2 then break end
      
      ent.xvel = -0.1 * (self.x - tarjet) / math.abs(self.x - tarjet)
      coroutine.yield()
    end
    
    self.xvel = 0
    return 
  end
  
  local function jump_attack()
    approach_to(4)
    
    self.xvel = 0.095 * sign(player.x - self.x)
    self.yvel = -0.28
    
    local blade = CreateFrame("Frame", ent.sprite)
    blade:SetPoint(0.5, 0, ent.sprite, "CENTER")
    blade:SetWidth(0.3)
    blade:SetHeight(1.4)
    blade:SetBackgroundColor(1.0, 0, 0)
    
    mstabs[blade] = true
    blade.behavior = {stagger = true, damage = 0.4}
    local et = self
    function blade:tick()
      self.x, self.y, self.width, self.height = self:GetXCenter(), self:GetYCenter(), self:GetWidth(), self:GetHeight()
      
      if et.freefall == false and et.yvel == 0 then
        death[self] = true
        mstabs[self] = nil
        self:Detach()
      end
    end
    blade:tick()
    monsters[blade] = true
    
    coroutine.yield()
    while self.freefall do coroutine.yield() end
  end
  local function normal_attack()
    approach_to(1)
    
    local blade = CreateFrame("Frame", ent.sprite)
    blade:SetPoint(0, 0.5, ent.sprite, "CENTER")
    blade:SetWidth(sign(player.x - self.x) * 0.9)
    blade:SetHeight(0.8)
    blade:SetBackgroundColor(1.0, 0, 0)
    
    mstabs[blade] = true
    blade.behavior = {damage = 0.2}
    local self = blade
    blade.tick = coroutine.wrap(function ()
      for i = 1, 8 do
        self.x, self.y, self.width, self.height = self:GetXCenter(), self:GetYCenter(), self:GetWidth(), self:GetHeight()
        coroutine.yield()
      end
      
      death[self] = true
      mstabs[self] = nil
      self:Detach()
      
      while true do coroutine.yield() end
    end)
    blade:tick()
    monsters[blade] = true
    
    coroutine.pause(12 + math.floor(math.random(6)))
  end
  
  local function defer_attack()
    for i = 1, 3 do
      approach_to(math.random() * 3 + 3)
      coroutine.pause(12)
    end
  end
  
  local function stdai()
    if math.random() < 0.3 then
      jump_attack()
    else
      normal_attack()
    end
    
    while true do
      if math.random() < 0.1 then
        jump_attack()
      elseif math.random() < 0.7 then
        normal_attack()
      else
        defer_attack()
      end
    end
  end
  
  ent.tick_default = ent.tick
  ent.tick = function ()
    if not ent.routine then
      -- here we replace the routine with the default routine
      if not ent.player then
        ent.routine = coroutine.wrap(stdai)
        ent:routine()
      end
    else
      if ent:routine() then ent.routine = nil end
    end
    
    ent:tick_default()
  end
  
  function ent:notify(txt)
    notify_item(self.id .. ": " .. txt)
  end
  
  function ent:do_stagger(direction)
    self:notify("Stagger")
    
    if not direction then direction = -self.direction end -- stagger backwards if we don't otherwise care
    
    self.routine = coroutine.wrap(function ()
      local maxs = 0.08
      local tim = 20
      for i = 1, tim do
        self.xvel = maxs * direction * (tim - i + 1) / tim
        coroutine.yield()
      end
      self.xvel = 0
      
      return true
    end)
    self:routine()
  end
  
  function ent:do_knockdown(nobounce)
    self:notify("Knockdown")
    
    if not nobounce then
      self.bouncefactor = 0.55
      self.bouncelimit = 0.01
    end
    self.freefall = true
    self.gravity = 1
    
    self.routine = coroutine.wrap(function ()
      while self.freefall do coroutine.yield() end
      while self.xvel ~= 0 do self.xvel = approach(self.xvel, 0, 0.01) coroutine.yield() end
      self.verbose = nil
      
      coroutine.pause(20)  -- get up
      
      self.bouncefactor = nil
      self.bouncelimit = nil
    
      return true
    end)
    self:routine()
  end
  
  function ent:take_damage(dmg)
    self:notify(string.format("%f damage", dmg))
  end
  
  function ent:do_domino()
    local et = self
    local domi = CreateFrame("Frame", self.sprite)
    domi:SetAllPoints()
    domi:SetBackgroundColor(0, 0, 1, 0.2)
    stabs[domi] = true
    domi.behavior = {}
    function domi:tick()
      self.x, self.y, self.width, self.height = self:GetXCenter(), self:GetYCenter(), self:GetWidth(), self:GetHeight()
      self.behavior.knockdown_dx = et.xvel * 0.5
      self.behavior.knockdown_dy = et.yvel * 0.5
      
      if et.xvel == 0 and et.yvel == 0 and et.freefall == false then
        death[self] = true
        stabs[self] = nil
        domi:Detach()
      end
    end
    domi:tick()
    monsters[domi] = true
    self.impacted[domi] = true
    domi.behavior.knockdown = true
    domi.behavior.damage = 1.0
  end
  
  ent.real = true
  ent.impacted = setmetatable({}, {__mode = "k"})
  
  return ent
end

local mid = 1
for _, v in pairs(terra.entities()) do
  local monst = NewMonster(v)
  
  if entities[v.id].player then
    player = monst
    player.player = true
    player.id = "Player"
  else
    monsters[monst] = true
    monst.id = string.format("Monster %d", mid)
    mid = mid + 1
  end
end

--[[ #####################################
                                 PLAYER CODE
#######################################]]

assert(player)
local walk_top_speed = 0.2
local run_top_speed = 0.2
local jump_top_speed = 0.2
local start_accel = 0.015
local stop_accel = 0.03
local stop_accel_air = 0.0040
local jump_yvel = 0.4

local jumplift_grav = 0.5
local jumpdown_grav = 1.5

player.stun = 0
player.mirror = true
player.direction = 1
function player:mover(x, y, jumpy)
  if self.invincibility == true then
    if not self.freefall then
      self.stun = 30
      self.invincibility = 60
    else
      x, y, jumpy = 0, 0, false
    end
  end
  
  if self.dead or self.stun > 0 then x = 0 y = 0 jumpy = false end
  
  if x ~= 0 then
    if self.state == "stopped" then
      self.state = "running"
    end
    
    self.direction = x / math.abs(x)
  elseif self.invincibility ~= true then
    local stop_acel = (self.freefall and stop_accel_air or stop_accel)
    if stop_acel > math.abs(self.xvel) then
      self.xvel = 0
      if not self.freefall then self.state = "stopped" end
    else
      if self.xvel > 0 then stop_acel = -stop_acel end
      self.xvel = self.xvel + stop_acel
    end
  end
  
  if self.gravity < jumpdown_grav then
    self.gravity = self.gravity + 0.025
  end
  
  if y < 0 and not self.freefall and jumpy then
    self.freefall = true
    self.gravity = jumplift_grav
    self.yvel = -jump_yvel
    self.state = "run_jump"
  end
  
  if y >= 0 and self.freefall and self.yvel < 0 and self.gravity < jumpdown_grav then
    self.yvel = self.yvel / 2
    self.gravity = jumpdown_grav
  end
  
  if self.state == "run_jump" and self.yvel > 0 then
    self.state = "run_jump_fall"
    self.gravity = jumpdown_grav
  end
  
  if x > 0 then
    self.xacel = start_accel
  elseif x < 0 then
    self.xacel = -start_accel
  else
    self.xacel = 0
  end
  
  if self.xacel * self.xvel < 0 then
    self.xacel = self.xacel * 2
  end
  
  if self.invincibility ~= true then
    local top_speed
    if self.state == "stopped" or self.state == "end_run_jump" then
      top_speed = walk_top_speed
    elseif self.state == "running" then
      top_speed = run_top_speed
    elseif self.state == "run_jump" or self.state == "run_jump_fall" or self.state == "start_run_jump" then
      top_speed = jump_top_speed
    else
      top_speed = 1000
    end
    
    local expected_speed = self.xvel + self.xacel
    if math.abs(expected_speed) > top_speed then
      self.xacel = (top_speed - math.abs(expected_speed)) * (expected_speed / math.abs(expected_speed))
    end
  end
  
  --[[
  local img
  if self.dead then
    img = "_corpse"
  elseif self.freefall then
    img = "_jump"
  elseif self.xvel == 0 then
    img = "_stand"
  else
    img = ""
  end
  
  local prefix = "bear"
  if bullet_life > 0 then
    prefix = "bear_cannon"  -- bearcannon
  end
  
  if self.current_tex ~= img then
    self.current_tex = img
    if img == "" then
      self.tex = NewSequence(prefix)
    else
      self.tex = Texture(prefix .. img)
    end
  end]]
  
  --if self.tex.increment then self.tex:increment(self.x, self.y) end
  
  if type(self.invincibility) == "number" then
    self.invincibility = self.invincibility - 1
    if self.invincibility <= 0 then
      self.invincibility = nil
    end
  end
  self.stun = self.stun - 1
end

local lastpoosh = {}
function DelayedKey(key, delay)
  if not lastpoosh[key] then lastpoosh[key] = 1000000 end   -- lotta frames
  return lastpoosh[key] and lastpoosh[key] < delay
end
monsters[{tick = function()
  for k in pairs(lastpoosh) do
    if WasKeyPressed(k) then
      lastpoosh[k] = 0
    else
      lastpoosh[k] = lastpoosh[k] + 1
    end
  end
end}] = true
local function make_direction(pdir, kdir)
  if kdir == "forward" then
    if pdir == 1 then
      return "arrow_right"
    else
      return "arrow_left"
    end
  end
  if kdir == "backward" then
    if pdir == 1 then
      return "arrow_left"
    else
      return "arrow_right"
    end
  end
  assert(false)
end

local playermodes = {
  neutral = function (self) return function ()
    local dx, dy = 0, 0
    local speed = 1
    
    if IsKeyDownFrame("z") then dy = dy - speed end
    if IsKeyDownFrame("arrow_left") then dx = dx - speed end
    if IsKeyDownFrame("arrow_right") then dx = dx + speed end
    
    self.dx, self.dy, self.jump = dx, dy, WasKeyPressed("z")
    
    if WasKeyPressed("c") then
      self.grabbed = nil
      local grabchunk = CreateFrame("Frame", player.sprite)
      grabchunk:SetPoint(0, 0.5, player.sprite, "CENTER")
      grabchunk:SetHeight(1)
      grabchunk:SetWidth(0.7 * self.direction)
      grabchunk:SetBackgroundColor(1, 0.8, 0.8)
      grabchunk.x, grabchunk.y, grabchunk.width, grabchunk.height = grabchunk:GetXCenter(), grabchunk:GetYCenter(), grabchunk:GetWidth(), grabchunk:GetHeight()
      for k in pairs(monsters) do
        if k.real and collide(k, grabchunk) then
          self.grabbed = k
          break
        end
      end
      
      if self.grabbed then
        self:set_mode("grab")
      end
      
      monsters[{tick = coroutine.wrap(function (self) coroutine.pause(10) grabchunk:Detach() return true end)}] = true
    elseif WasKeyPressed("x") then
      self:set_mode("stab_init")
    end
  end end,
  stab_init = function (self) return coroutine.wrap(function ()
    local stabfix = "neutral"
    if IsKeyDownFrame(make_direction(self.direction, "forward")) then
      stabfix = "forward"
    elseif IsKeyDownFrame(make_direction(self.direction, "backward")) then
      stabfix = "backward"
    elseif IsKeyDownFrame("arrow_up") then
      stabfix = "up"
    elseif IsKeyDownFrame("arrow_down") then
      stabfix = "down"
    end
    
    if self.freefall then
      stabfix = "aerial_" .. stabfix
    end
    
    self:set_mode("stab_" .. stabfix)
  end) end,
  grab = function (self) return coroutine.wrap(function ()
    local punches = 0
    
    for i = 1, 90 do
      self.nomove = true
      self.freefall = true
      self.gravity = 0
      self.xvel = 0
      self.yvel = 0
      
      self.grabbed.xvel = 0
      self.grabbed.yvel = 0
      self.grabbed.gravity = 0
      self.grabbed.freefall = true
      
      if WasKeyPressed("x") then
        print("slash")
        punches = punches + 1
        if punches == 5 then
          self:set_mode("neutral")
          self.grabbed.xvel = self.direction * 0.1
          self.grabbed.yvel = -0.1
          self.grabbed.freefall = true
          self.grabbed.gravity = 0.9
          self.grabbed:do_knockdown()
        end
      elseif WasKeyPressed("z") then
        print("toss")
        
        self:set_mode("neutral")
        if IsKeyDownFrame("arrow_up") then
          self.grabbed.xvel = 0
          self.grabbed.yvel = -0.4
        elseif IsKeyDownFrame("arrow_down") then
          self.grabbed.xvel = 0
          self.grabbed.yvel = 0.4
        elseif IsKeyDownFrame("arrow_left") then
          self.grabbed.xvel = -0.3
          self.grabbed.yvel = 0
        elseif IsKeyDownFrame("arrow_right") then
          self.grabbed.xvel = 0.3
          self.grabbed.yvel = 0
        else
          self.grabbed.xvel = self.direction * 0.13
          self.grabbed.yvel = -0.13
        end
        
        self.grabbed.freefall = true
        self.grabbed.gravity = 0.9
        self.grabbed:do_knockdown()
        self.grabbed:do_domino()
      end
      coroutine.yield()
    end
    
    self.grabbed.xvel = 0
    self.grabbed.yvel = 0
    self.grabbed.gravity = 1
    self.grabbed.freefall = true
    
    self:set_mode("neutral")
  end) end,
}

do
  local function stabbity(data)
    local dir = data.name
    local sx, sy, ex, ey = unpack(data.bounds)
    local preroll, duration, cooldown = unpack(data.frames)
    playermodes["stab_" .. dir] = function(self) return coroutine.wrap(function()
      coroutine.pause(preroll)
      
      local sd = self.direction -- this isn't performance, we're actually storing it
      local stab = CreateFrame("Frame", player.sprite)
      stab:SetPoint("TOPLEFT", player.sprite, "CENTER", sx * sd, sy)
      stab:SetPoint("BOTTOMRIGHT", player.sprite, "CENTER", ex * sd, ey)
      stab:SetBackgroundColor(1, 1, 1)
      stab.x, stab.y, stab.width, stab.height = stab:GetXCenter(), stab:GetYCenter(), stab:GetWidth(), stab:GetHeight()
      stab.behavior = {stagger = data.stagger, stagger_direction = (data.stagger_directional and sd), knockdown = data.knockdown, knockdown_dx = data.knockdown_dx, knockdown_dy = data.knockdown_dy, knockdown_nobounce = data.knockdown_nobounce, damage = data.damage}
      stabs[stab] = true
      
      monsters[stab] = true
      function stab:tick()
        stab.x, stab.y = stab:GetXCenter(), stab:GetYCenter()
      end
      
      
      coroutine.pause(duration)
      
      stab:Detach()
      stabs[stab] = nil
      
      coroutine.pause(cooldown)
      
      player:set_mode("neutral")
    end) end
  end
  
  stabbity{name = "forward",
    bounds = {0, -0.2, 2.2, 0},
    frames = {8, 14, 12},
    stagger = true,
    stagger_directional = true,
    damage = 1.0,
  }
  stabbity{name = "backward",
    bounds = {0, 0, -0.8, -0.2},
    frames = {3, 9, 12},
    stagger = true,
    stagger_directional = true,
    damage = 1.0,
  }
  stabbity{name = "down",
    bounds = {-3, 0.2, 3, 0.6},
    frames = {6, 15, 2},
    knockdown = true,
    knockdown_dx = 0,
    knockdown_dy = -0.3,
    knockdown_nobounce = true,
    damage = 0,
  }
  stabbity{name = "up",
    bounds = {-0.1, -1.7, 0.1, 0},
    frames = {5, 15, 10},
    damage = 1.0,
  }
  stabbity{name = "neutral",
    bounds = {0, -0.4, 1.1, 0.4},
    frames = {0, 5, 2},
    damage = 0.4,
  }
  
  stabbity{name = "aerial_forward",
    bounds = {0, -0.2, 1.8, 0},
    frames = {8, 5, 12},
    damage = 1.0,
  }
  stabbity{name = "aerial_backward",
    bounds = {0, 0, -0.8, -0.2},
    frames = {3, 3, 12},
    damage = 1.0,
  }
  stabbity{name = "aerial_down",
    bounds = {-0.1, 1.7, 0.1, 0},
    frames = {4, 15, 15},
    stagger = true,
    damage = 1.5,
  }
  stabbity{name = "aerial_up",
    bounds = {-0.1, -1.7, 0.1, 0},
    frames = {5, 8, 10},
    stagger = true,
    damage = 1.0,
  }
  stabbity{name = "aerial_neutral",
    bounds = {-0.8, -0.4, 0.8, 0.4},
    frames = {0, 5, 10},
    stagger = true,
    damage = 1.0,
  }
end

function player:set_mode(modename)
  self.behave = playermodes[modename](self)
  if modename ~= "neutral" then
    self:behave()
  end
end
player:set_mode("neutral")

--[[ #####################################
                                 CORE
#######################################]]


local function focusize(oldcenter, focuspoint, slack)
  if math.abs(oldcenter - focuspoint) > slack then
    oldcenter = approach(oldcenter, focuspoint, math.max(0.03, math.abs(oldcenter - focuspoint) / 40))
  end
  return oldcenter
end

local function do_assault(stabbing, beingstabbed)
  for s in pairs(stabbing) do
    for m in pairs(beingstabbed) do
      if m.impacted and not m.impacted[s] and collide(m, s) then
        m.impacted[s] = true
        if s.behavior.stagger then
          m:do_stagger(s.behavior.stagger_direction)
        end
        if s.behavior.knockdown then
          m.xvel = s.behavior.knockdown_dx
          m.yvel = s.behavior.knockdown_dy
          m:do_knockdown(s.behavior.knockdown_nobounce)
        end
        if s.behavior.damage then
          m:take_damage(s.behavior.damage)
        end
      end
    end
  end
end

function tick_loop(...)
  collectgarbage("stop")
  
  player.dx, player.dy, player.jump, player.nomove = nil, nil, nil
  player:behave()
  if not player.nomove then player:mover(player.dx or 0, player.dy or 0, player.jump) end
  player:tick()
  
  perfbar(1, 0, 0, function ()
    for k in pairs(monsters) do
      if k.tick then
        if k:tick() then
          death[k] = true
        end
      end
    end
  end)
  
  for k in pairs(death) do
    monsters[k] = nil
  end
  death = {}
  
  do_assault(stabs, monsters)
  do_assault(mstabs, {[player] = true})
  
  xcenter = focusize(xcenter, player.x + player.direction * 5, 4)
  ycenter = focusize(ycenter, player.y, 4)
end
function render(...)
  gameworld:SetCoordinateScale(xcenter, ycenter, 32)
  UIParent:Render()
end

